(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.1'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     86377,       2359]*)
(*NotebookOutlinePosition[     87195,       2389]*)
(*  CellTagsIndexPosition[     87121,       2383]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["Transformada de Fourier Discreta", "Title"],

Cell[TextData[StyleBox["Javier P\[EAcute]rez Gonz\[AAcute]lez\nDepartamento \
de An\[AAcute]lisis Matem\[AAcute]tico\nUniversidad de Granada",
  FontSize->12]], "Author"],

Cell[CellGroupData[{

Cell["Presentaci\[OAcute]n", "Section"],

Cell[TextData[{
  "Esta pr\[AAcute]ctica es una mezcla de teor\[IAcute]a y de aplicaciones pr\
\[AAcute]cticas de la teor\[IAcute]a. Me ha parecido necesario desarrollar \
algunos aspectos de la transformada de Fourier discreta que completan lo \
visto en el curso y que tienen aplicaciones muy bonitas para el tratamiento \
digital de se\[NTilde]ales. En esta pr\[AAcute]ctica te propongo ejercicios \
muy variados: filtrado de se\[NTilde]ales de sonido, tratamiento de im\
\[AAcute]genes y otros de contenido m\[AAcute]s te\[OAcute]rico. Tambi\
\[EAcute]n aprender\[AAcute]s a usar algunos comandos y herramientas que \
tiene ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " para trabajar con sonidos. "
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Introducci\[OAcute]n", "Section"]], "Section"],

Cell[TextData[{
  "Hemos visto en clase de teor\[IAcute]a que la Transformada de Fourier \
Discreta (DFT) de un vector ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["y",
            FontWeight->"Bold"], "=", \((y\_0, y\_1,  ... , y\_\(N - 1\))\)}],
         TraditionalForm]]],
  " (que interpretamos como una se\[NTilde]al discreta en el tiempo y peri\
\[OAcute]dica con per\[IAcute]odo ",
  StyleBox["N",
    FontSlant->"Italic"],
  ", esto es, ",
  Cell[BoxData[
      \(TraditionalForm\`y\_\(k + N\) = y\_k\)]],
  " para todo ",
  Cell[BoxData[
      \(TraditionalForm\`k \[Element] \[DoubleStruckCapitalZ]\)]],
  ") es el vector ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["Y",
            FontWeight->"Bold"], 
          StyleBox["=",
            FontWeight->"Plain"], 
          StyleBox[" ",
            FontWeight->"Plain"], 
          RowBox[{
            RowBox[{"\[ScriptCapitalF]", "(", 
              StyleBox["y",
                FontWeight->"Bold"], 
              StyleBox[")",
                FontWeight->"Bold"]}], 
            StyleBox["=",
              FontWeight->"Plain"], \((Y\_0, 
              Y\_1, \(\(...\) \(Y\_\(N - 1\)\)\))\)}]}], TraditionalForm]]],
  " cuyas componentes vienen dadas por "
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`Y\_n = \(1\/N\) \(\[Sum]\+\(k = 0\)\%\(N - 1\)\(\(y\_k\
\) \(\[ExponentialE]\^\(\(-2\)\ \[ImaginaryI]\ \[Pi]\ n\ k/
                    N\)\)\(\ \ \ \ \ \ \ \ \ \ \ \ \)\((n = 0, 1, 2,  ... , 
              N - 1)\)\(\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \)\((1)\
\)\(\ \ \ \ \ \ \ \ \ \ \ \)\)\)\)], "Text",
  TextAlignment->Center],

Cell["A su vez la se\[NTilde]al original se puede expresar en la forma", \
"Text"],

Cell[BoxData[
    \(TraditionalForm\`y\_n = \[Sum]\+\(k = 0\)\%\(N - 1\)\(\(Y\_k\) \(\
\[ExponentialE]\^\(2\ \[ImaginaryI]\ \[Pi]\ n\ k/
                  N\)\)\(\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \)\((\
n = 0, 1, 2,  ... , 
            N - 1)\)\(\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \)\((2)\)\(\ \ \ \
\ \ \ \ \ \)\)\)], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Los  ",
  Cell[BoxData[
      \(TraditionalForm\`Y\_n\)]],
  " son llamados los ",
  StyleBox["coeficientes espectrales",
    FontSlant->"Italic"],
  " de la se\[NTilde]al ",
  Cell[BoxData[
      FormBox[
        StyleBox["y",
          FontWeight->"Bold"], TraditionalForm]]],
  ". La igualdad (1) suele llamarse ",
  StyleBox["ecuaci\[OAcute]n de an\[AAcute]lisis",
    FontSlant->"Italic"],
  " y (2) se llama ",
  StyleBox["ecuaci\[OAcute]n de s\[IAcute]ntesis",
    FontSlant->"Italic"],
  ".  La ecuaci\[OAcute]n de s\[IAcute]ntesis nos dice que cualquier sucesi\
\[OAcute]n de ",
  StyleBox["N",
    FontSlant->"Italic"],
  " t\[EAcute]rminos puede representarse por una superposici\[OAcute]n (suma) \
de ",
  StyleBox["N",
    FontSlant->"Italic"],
  " exponenciales complejas arm\[OAcute]nicamente relacionadas. La ",
  StyleBox["frecuencia fundamental",
    FontSlant->"Italic"],
  " (en ciclos por segundo) en (2) es ",
  Cell[BoxData[
      \(TraditionalForm\`\[Omega] = 1/N\)]],
  ". F\[IAcute]jate que el coeficiente que corresponde a la frecuencia ",
  Cell[BoxData[
      \(TraditionalForm\`k\/N\)]],
  "es justamente ",
  Cell[BoxData[
      \(TraditionalForm\`Y\_k\)]],
  ". Observa que ",
  Cell[BoxData[
      \(TraditionalForm\`Y\_\(k + N\) = \(\(Y\_k\)\(.\)\)\)]],
  "\nEl espectro de la se\[NTilde]al ",
  StyleBox["y",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " es el conjunto ",
  Cell[BoxData[
      \(TraditionalForm\`{\((n/N, Y\_n)\) : 
          n \[Element] \[DoubleStruckZ]}\)]],
  ". El espectro de amplitudes es el conjunto  ",
  Cell[BoxData[
      \(TraditionalForm\`{\((n/N, Abs[Y\_n])\) : 
          n \[Element] \[DoubleStruckZ]}\)]],
  " y el espectro de fases es el conjunto ",
  Cell[BoxData[
      \(TraditionalForm\`{\((n/N, Arg[Y\_n])\) : 
          n \[Element] \[DoubleStruckZ]}\)]],
  ". Dichos conjuntos suelen representarse por segmentos de l\[IAcute]nea que \
unen los puntos ",
  Cell[BoxData[
      \(TraditionalForm\`\((n/N, 0)\)\)]],
  " con los puntos del espectro correspondiente. Debido a la periodicidad de \
los ",
  Cell[BoxData[
      \(TraditionalForm\`Y\_n\)]],
  " es suficiente representar dichos espectros para ",
  StyleBox["N ",
    FontSlant->"Italic"],
  "valores consecutivos de ",
  StyleBox["n",
    FontSlant->"Italic"],
  ". Usualmente se eligen los valores ",
  Cell[BoxData[
      \(TraditionalForm\`n = 0, 1, 2,  ... , N - 1\)]],
  ". Otra posible elecci\[OAcute]n, a mi modo de ver m\[AAcute]s conveniente \
pero menos usada, ser\[IAcute]a ",
  Cell[BoxData[
      \(TraditionalForm\`n = \(-N\)/2 + 1, \ \(-N\)/2 + 2,  ... , N/2 - 1, 
      N/2\)]],
  " cuyo peque\[NTilde]o inconveniente es que obliga a considerar que ",
  Cell[BoxData[
      \(TraditionalForm\`N\)]],
  "es par. Nosotros seguiremos la costumbre y representaremos la DFT para \
valores ",
  Cell[BoxData[
      \(TraditionalForm\`n = 0, 1, 2,  ... , N - \ 1\)]],
  ". El inconveniente de esta elecci\[OAcute]n es que que no es \
sim\[EAcute]trica respecto del origen lo que debe tenerse en cuenta al \
interpretar la representaci\[OAcute]n gr\[AAcute]fica del espectro. \n",
  StyleBox["En todo lo que sigue hay que considerar que N  es un \
n\[UAcute]mero par",
    FontSlant->"Italic"],
  ". Observa que, como consideramos se\[NTilde]ales reales, ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[\(y\_k\),
            "TraditionalForm"], "\[Element]", "\[DoubleStruckCapitalR]"}], 
        TraditionalForm]]],
  ", se verifica que ",
  Cell[BoxData[
      \(TraditionalForm\`Y\_\(-n\) = Y\&__\_n\)]],
  " donde la barra indica complejo conjugado. Como ",
  Cell[BoxData[
      \(TraditionalForm\`Y\_\(-n\) = Y\_\(N - n\)\)]],
  " haciendo ",
  Cell[BoxData[
      \(TraditionalForm\`n = N/2 - k\)]],
  " obtenemos que ",
  Cell[BoxData[
      \(TraditionalForm\`Y\_\(N/2 + k\) = Y\&__\_\(N/2 - k\)\)]],
  " de donde se deduce que ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(|\)\(Y\_\(N/2 + 
                k\)\)\(|\)\) = \(\(\(|\)\(Y\&__\_\(N/2 - 
                  k\)\)\(|\)\) = \(\(|\)\(Y\_\(N/2 - k\)\)\(|\)\)\)\)]],
  " , esto es, ",
  StyleBox["el espectro de amplitudes es sim\[EAcute]trico respecto a ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  Cell[BoxData[
      \(TraditionalForm\`N/2\)],
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " y ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{"Arg", "(", 
            FormBox[\(Y\_\(N/2 + k\)\),
              "TraditionalForm"], ")"}], 
          FormBox[
            RowBox[{"=", 
              RowBox[{"Arg", 
                FormBox[
                  RowBox[{\((Y\&__\_\(N/2 - k\))\), "=", 
                    RowBox[{"-", 
                      RowBox[{"Arg", "(", 
                        FormBox[\(Y\_\(N/2 - k\)\),
                          "TraditionalForm"], ")"}]}]}],
                  "TraditionalForm"]}]}],
            "TraditionalForm"]}], TraditionalForm]]],
  ", es decir, ",
  StyleBox["el espectro de fases es antisim\[EAcute]trico respecto a ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  Cell[BoxData[
      \(TraditionalForm\`N/2\)],
    FontWeight->"Bold",
    FontSlant->"Italic"],
  ". Si, adem\[AAcute]s, la se\[NTilde]al ",
  StyleBox["y",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " es ",
  StyleBox["par",
    FontSlant->"Italic"],
  ", es decir, ",
  Cell[BoxData[
      \(TraditionalForm\`y\_k = \(y\_\(-k\) = y\_\(N - k\)\)\)]],
  ", equivalentemente ",
  Cell[BoxData[
      \(TraditionalForm\`y\_\(N/2 - k\) = y\_\(N/2 + k\)\)]],
  ", entonces es f\[AAcute]cil comprobar que ",
  Cell[BoxData[
      \(TraditionalForm\`Y\_\(-n\) = Y\_n\)]],
  " y la DFT tambi\[EAcute]n es real y par pues ",
  Cell[BoxData[
      \(TraditionalForm\`Y\_n = Y\&__\_n\)]],
  " e ",
  Cell[BoxData[
      \(TraditionalForm\`Y\_\(N/2 + k\) = Y\_\(N/2 - k\)\)]],
  ".\nEs f\[AAcute]cil definir un comando que calcule simb\[OAcute]licamente \
dicha transformada. Observa que ",
  Cell[BoxData[
      \(TraditionalForm\`N\ Y\_\(\(n\)\(\ \)\)\)]],
  "se obtiene haciendo el producto escalar en ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalC]\^N\)]],
  "del vector  ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["y",
            FontWeight->"Bold"], "=", \((y\_0, y\_1,  ... , y\_\(N - 1\))\)}],
         TraditionalForm]]],
  " por el vector "
}], "Text"],

Cell[BoxData[
    FormBox[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["\[Omega]",
              FontWeight->"Bold"], "n"], "=", 
          
          RowBox[{\((1, \[ExponentialE]\^\(2\ \[ImaginaryI]\ \[Pi]\ n/N\), \
\[ExponentialE]\^\(2\ \[ImaginaryI]\ \[Pi]\ n\ 2/N\), \[ExponentialE]\^\(2\ \
\[ImaginaryI]\ \[Pi]\ n\ 3/N\),  .. , \[ExponentialE]\^\(2\ \[ImaginaryI]\ \
\[Pi]\ n\ \((N - 1)\)/N\))\), "=", 
            
            RowBox[{\((1, \[Omega]\^n, \[Omega]\^\(2\ n\), \[Omega]\^\(3\ \
n\),  .. , \[Omega]\^\(\((N - 1)\) n\))\), "    ", 
              FormBox[
                
                RowBox[{\(0 \[LessEqual] \ n \[LessEqual] \ N - 1\), ",", 
                  "  ", 
                  
                  FormBox[\(\[Omega] = \[ExponentialE]\^\(2  \[ImaginaryI]\ \
\[Pi]/N\)\),
                    "TraditionalForm"], " "}],
                "TraditionalForm"]}]}]}],
        "TraditionalForm"], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell["siendo, esto es:", "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{"\t", 
        RowBox[{
          FormBox[
            RowBox[{\(Y\_n\), "=", 
              RowBox[{\(1\/N\), 
                RowBox[{"(", 
                  RowBox[{
                    StyleBox["y",
                      FontWeight->"Bold"], 
                    StyleBox["|",
                      FontWeight->"Plain"], 
                    SubscriptBox[
                      StyleBox["\[Omega]",
                        FontWeight->"Bold"], "n"]}], ")"}]}]}],
            "TraditionalForm"], "\t  ", 
          FormBox[\(\((n = 0, 1, 2,  ... , N - 1)\)\(\ \)\),
            "TraditionalForm"]}]}], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[BoxData[{
    \(Off[General::spell1]\  (*\ 
      para\ que\ Mathematica\ no\ moleste\ con\ mensajes\ relativos\ a\ \
nombres\ parecidos\ *) \), "\[IndentingNewLine]", 
    \(Off[General::spell]\)}], "Input"],

Cell[CellGroupData[{

Cell["Ejercicio 1", "Exercise"],

Cell[TextData[{
  "a) Define un comando que proporcione simb\[OAcute]licamente los vectores \
\[Omega][n,N]  (",
  Cell[BoxData[
      \(TraditionalForm\`0 \[LessEqual] n \[LessEqual] N - 1\)]],
  ").\nb) Comprueba para ",
  Cell[BoxData[
      \(TraditionalForm\`N = 6\)]],
  " que los vectores antes definidos forman una base ortogonal de ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalC]\^6\)]],
  ". Usa el comando Simplify[ ] si es preciso.\nc) Define un comando \
DFT[lista] que proporcione la transformada de Fourier discreta de \"lista\". \
Usa para ello los vectores \[Omega][n,N] y el producto escalar.\nObservaci\
\[OAcute]n: Claro est\[AAcute] que este comando no es \[UAcute]til para hacer \
c\[AAcute]lculos largos, pero tiene la ventaja de que puede trabajar simb\
\[OAcute]licamente lo que nos permite entender bien lo que hace. \nd) Decimos \
que la se\[NTilde]al ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["y",
            FontWeight->"Bold"], "=", \((y\_0, y\_1,  ... , y\_\(N - 1\))\)}],
         TraditionalForm]]],
  " es par si es sim\[EAcute]trica respecto de ",
  Cell[BoxData[
      \(TraditionalForm\`N/2\)]],
  " (suponemos que ",
  StyleBox["N",
    FontSlant->"Italic"],
  " es par), es decir, si ",
  Cell[BoxData[
      \(TraditionalForm\`y\_\(N/2 - k\) = y\_\(N/2 + k\)\)]],
  " para ",
  Cell[BoxData[
      \(TraditionalForm\`k = 0, 1,  ... , \ N/2 - 1\)]],
  ". Decimos que ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["y",
            FontWeight->"Bold"], "=", \((y\_0, y\_1,  ... , y\_\(N - 1\))\)}],
         TraditionalForm]]],
  " es impar si es antisim\[EAcute]trica respecto de ",
  Cell[BoxData[
      \(TraditionalForm\`N/2\)]],
  ", es decir, si ",
  Cell[BoxData[
      \(TraditionalForm\`y\_\(N/2 - k\) = \(-y\_\(N/2 + k\)\)\)]],
  " para ",
  Cell[BoxData[
      \(TraditionalForm\`k = 0, 1,  ... , \ N/2 - 1\)]],
  ". \nDefine comandos \"par[se\[NTilde]al]\"  (\"impar[se\[NTilde]al]\") que \
transformen una se\[NTilde]al (finita) dada en otra se\[NTilde]al par (impar) \
de forma que se verifique la igualdad\n\t\t\tse\[NTilde]al = \
par[se\[NTilde]al] + impar[se\[NTilde]al]\nadem\[AAcute]s, si la \
se\[NTilde]al es par debe ser  se\[NTilde]al = par[se\[NTilde]al].\n\
Sugerencia: Usa el comando Reverse[].\ne) Define un comando \"rlist[n]\" que \
genere aleatoriamente una lista de n n\[UAcute]meros. Define a= rlist[32]. \
Calcula DFT[par[a]] y comprueba por simple inspecci\[OAcute]n que todos sus \
elementos son reales y es par. Calcula DFT[impar[a]] y comprueba por simple \
inspecci\[OAcute]n que todos sus elementos, excepto el primero y el que ocupa \
el lugar 17, son imaginarios puros y es impar. Comprueba, usando ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", que DFT[a] = DFT[par[a]] + DFT[impar[a]].\nSugerencia: Debes usar el \
comando Chop[ ] para eliminar las peque\[NTilde]as partes imaginarias o \
reales procedentes de errores de redondeo.\nf) Define un comando \
\"InverseDFT[lista]\" que calcule la inversa de la transformada de Fourier \
discreta. Comprueba dicho comando con algunos ejemplos concretos."
}], "ExerciseText"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Comparaci\[OAcute]n de espectros", "Section"],

Cell["\<\
Esta secci\[OAcute]n es para que aprendas a interpretar correctamente la \
representaci\[OAcute]n gr\[AAcute]fica de una transformada de Fourier \
discreta. Al final de esta secci\[OAcute]n te propongo un ejercicio que \
puedes hacer sin necesidad de leer lo que le precede, pero creo que lo que \
sigue tiene suficiente inter\[EAcute]s y merece la pena leerlo con atenci\
\[OAcute]n.\
\>", "Text"],

Cell[TextData[{
  "Recuerda que el espectro de una se\[NTilde]al peri\[OAcute]dica cuya serie \
de Fourier compleja es ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(\[Sum]\+\(k \[Element] \[DoubleStruckCapitalZ]\)c\_k\ \
e\^\(2  \[ImaginaryI]\ \[Pi]\ k\ t/T\)\),
          FontWeight->"Bold"], TraditionalForm]]],
  " se define como el conjunto de puntos ",
  Cell[BoxData[
      \(TraditionalForm\`{\((n/T, c\_n)\) : 
          n \[Element] \[DoubleStruckZ]}\)]],
  ". An\[AAcute]logamente, el espectro de una se\[NTilde]al peri\[OAcute]dica \
",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["y",
            FontWeight->"Bold"], "=", \((y\_0, y\_1,  ... , y\_\(N - 1\))\)}],
         TraditionalForm]]],
  " es el conjunto ",
  Cell[BoxData[
      \(TraditionalForm\`{\((n/N, Y\_n)\) : 
          n \[Element] \[DoubleStruckZ]}\)]],
  ". \nVamos a comparar el espectro ",
  Cell[BoxData[
      \(TraditionalForm\`{\((n/T, c\_n)\) : 
          n \[Element] \[DoubleStruckZ]}\)]],
  " de una se\[NTilde]al peri\[OAcute]dica ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " y el espectro de una muestra de dicha se\[NTilde]al ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["y",
            FontWeight->"Bold"], "=", \((y\_0, y\_1,  ... , y\_\(N - 1\))\)}],
         TraditionalForm]]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm\`y\_k = f(k\ T/N)\)]],
  ". Ejecuta las celdas que siguen y procura entender lo que se hace."
}], "Text"],

Cell[BoxData[
    \(\(\( (*\ 
      funci\[OAcute]n\ pulso\ rectangular\ *) \)\(\[IndentingNewLine]\)\(\
\[CapitalPi][t_] := 1\  /; Abs[t] < 1/2\[IndentingNewLine]
    \[CapitalPi][t_] := 
      0\  /; \ Abs[t] \[GreaterEqual] 1/2\[IndentingNewLine]
    \(Plot[\[CapitalPi][t], {t, \(-6\), 6}, 
        Ticks \[Rule] {Range[\(-5\), 5], Automatic}];\)\)\)\)], "Input"],

Cell[BoxData[
    \(\(\(P[t_] := If[Abs[t - 5  Round[t/5]] < 1/2, 1, 0]\  (*\ 
      periodizaci\[OAcute]n\ con\ per\[IAcute]odo\ 5\ de\ la\ funci\[OAcute]n\
\ \[CapitalPi][t]\ *) \ \[IndentingNewLine]
    \(Plot[P[t], {t, \(-6\), 6}, 
        Ticks \[Rule] {Range[\(-5\), 5], Automatic}];\)\)\( (*\ 
      representaci\[OAcute]n\ gr\[AAcute]fica\ de\ la\ periodizaci\[OAcute]n\ \
con\ per\[IAcute]odo\ 5\ de\ la\ funci\[OAcute]n\ \[CapitalPi][
          t]\ *) \)\(\ \)\)\)], "Input"],

Cell[BoxData[{
    \(c[n_] = 
      Simplify[\((1/5)\)*
          Integrate[Exp[\(-2\)\ \[Pi]\ I\ n\ t/5], {t, \(-1\)/2, 1/2}], 
        n \[Element] Integers] (*\ 
      coeficientes\ de\ Fourier\ de\ P[
          t]\ *) \[IndentingNewLine]\), "\[IndentingNewLine]", 
    \(c[0] = Simplify[\((1/5)\)*Integrate[1, {t, \(-1\)/2, 1/2}]]\)}], "Input"],

Cell[TextData[{
  "Como la funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`P[t]\)]],
  " es real y par sus coeficientes de Fourier son reales (y pares ",
  Cell[BoxData[
      \(TraditionalForm\`c[\(-k\)] = c[k]\)]],
  ") por lo que podemos representar el espectro de ",
  Cell[BoxData[
      \(TraditionalForm\`P[t]\)]],
  " f\[AAcute]cilmente como sigue."
}], "Text"],

Cell[BoxData[{
    \(\(puntos = 
        Transpose[{\(1\/5\) Range[\(-15\), 15], 
            Table[c[n], {n, \(-15\), 15, 1}]}];\)\), "\[IndentingNewLine]", 
    \(\(Show[{ListPlot[puntos, PlotStyle \[Rule] {PointSize[0.02], Hue[0]}, 
            DisplayFunction \[Rule] Identity], 
          ListPlot[puntos, PlotJoined \[Rule] True, 
            DisplayFunction \[Rule] Identity]}, 
        DisplayFunction \[Rule] $DisplayFunction];\)\), \
"\[IndentingNewLine]", 
    \( (*\ 
      hemos\ representado\ los\ primeros\ 31\ coeficientes\ *) \)}], "Input"],

Cell["\<\
Tomamos ahora una muestra de la funci\[OAcute]n formada por 32 valores \
igualmente espaciados a lo largo de un per\[IAcute]odo.\
\>", "Text"],

Cell[BoxData[
    \(muestra = P /@ \((\(5\/32\) Range[0, 31])\)\)], "Input"],

Cell[BoxData[
    \(\(\(par[muestra]\)\(\[Equal]\)\(muestra\)\(\ \)\( (*\ 
        comprobamos\ que\ la\ muestra\ obtenida\ es\ par\ *) \)\)\)], "Input"],

Cell[BoxData[{
    \(\(puntos = 
        Transpose[{\(1\/5\) Range[0, 31], 
            Chop[N[DFT[muestra]]]}];\)\), "\[IndentingNewLine]", 
    \(\(Show[{ListPlot[puntos, PlotStyle \[Rule] {PointSize[0.02], Hue[0]}, 
            DisplayFunction \[Rule] Identity], 
          ListPlot[puntos, PlotJoined \[Rule] True, 
            DisplayFunction \[Rule] Identity]}, 
        DisplayFunction \[Rule] $DisplayFunction];\)\), \
"\[IndentingNewLine]", 
    \( (*\ representamos\ el\ espectro\ de\ la\ muestra\ *) \)}], "Input"],

Cell[TextData[{
  "Aparentemente el resultado obtenido es muy distinto del anterior. Lo que \
ocurre es que en la transformadad de Fourier discreta se acostumbra a \
representar las frecuencias para valores de ",
  Cell[BoxData[
      \(TraditionalForm\`k = 0, 1, 2,  ... , N - 1\)]],
  " pero recuerda que ",
  StyleBox["los coeficientes ",
    FontSlant->"Italic"],
  Cell[BoxData[
      \(TraditionalForm\`Y\_k\)],
    FontSlant->"Italic"],
  StyleBox[" de la segunda mitad de la DFT correspondientes a los valores ",
    FontSlant->"Italic"],
  Cell[BoxData[
      \(TraditionalForm\`k = N/2, N/2 + 1,  ... , N - 1\)],
    FontSlant->"Italic"],
  StyleBox[" son iguales, debido a la periodicidad de la DFT, a los que se \
obtienen para los valores ",
    FontSlant->"Italic"],
  Cell[BoxData[
      \(TraditionalForm\`k = \(-N\)/2, \(-N\)/2 + 
        1,  ... , \(\(-1\)\(\ \)\)\)],
    FontSlant->"Italic"],
  StyleBox["y por tanto representan frecuencias negativas que se combinan con \
las frecuencias correspondientes a la primera mitad de la transformada para \
reconstruir la se\[NTilde]al",
    FontSlant->"Italic"],
  ". Para recuperar la gr\[AAcute]fica anterior lo \[UAcute]nico que hay que \
hacer es \"doblar por la mitad\" la transformada de Fourier discreta. Esto \
puede hacerse con el comando RotateLeft[ ]."
}], "Text"],

Cell[BoxData[{
    \(\(puntos = 
        Transpose[{\(1\/5\) Range[\(-16\), 15], 
            RotateLeft[Chop[N[DFT[muestra]]], 
              16]}];\)\), "\[IndentingNewLine]", 
    \(\(Show[{ListPlot[puntos, PlotStyle \[Rule] {PointSize[0.02], Hue[0]}, 
            DisplayFunction \[Rule] Identity], 
          ListPlot[puntos, PlotJoined \[Rule] True, 
            DisplayFunction \[Rule] Identity]}, 
        DisplayFunction \[Rule] $DisplayFunction];\)\)}], "Input"],

Cell["\<\
En la gr\[AAcute]fica anterior el valor central corresponde a la frecuencia \
nula. Por estas causas, para evitar interpretaciones incorrectas, es \
frecuente representar solamente la primera mitad de la transformadad de \
Fourier discreta. Por supuesto, lo usual es representar el espectro de \
amplitudes pues, en general, la transformadad de Fourier discreta tiene \
valores complejos.\
\>", "Text"],

Cell["\<\
En el siguiente ejemplo puedes comprobar c\[OAcute]mo la transformada de \
Fourier discreta detecta las frecuencias presentes en una muestra.\
\>", "Text"],

Cell[BoxData[{
    \(Clear[f, muestra]\), "\[IndentingNewLine]", 
    \(\(\(f[t_] := 
        Sin[2  \[Pi]\ t] +  .5  Sin[3*2  \[Pi]\ t] + 
          Cos[4*2  \[Pi]\ t] +  .5  Cos[6*2  \[Pi]\ t] + 
          2  Cos[12*2  \[Pi]\ t] +  .75  Sin[15*2  \[Pi]\ t];\)\(\n\)
    \) (*\ 
      f\ es\ una\ se\[NTilde]al\ peri\[OAcute]dica\ con\ per\[IAcute]odo\ 1\ \
obtenida\ por\ superposici\[OAcute]n\ de\ sinusoides\ de\ frecuencias\ 1, 3, 
      4, 6, 12\ y\ 15\ *) \), "\[IndentingNewLine]", 
    \(plotDFT[k_] := 
      Module[{puntos, puntitos, bipuntos}, \[IndentingNewLine]muestra[k] := 
          f[Range[0, k - 1]/k]; \  (*\ 
          una\ muestra\ de\ k\ elementos\ obtenida\ por\ divisi\[OAcute]n\ en\
\ intervalos\ de\ \ longitud\ 1/k\ del\ intervalo\ [0, 
              1]\ *) \[IndentingNewLine]puntos[k] := 
          Transpose[{Range[0, k - 1]/k, 
              Abs[DFT[muestra[k]]]}]; \[IndentingNewLine]puntitos[k] := 
          Join[{PointSize\ [0.016], Hue[0]}, 
            Point /@ puntos[k]]; \[IndentingNewLine]bipuntos[k] := 
          Join[puntos[
                k] /. {x_, 
                  y_} \[Rule] {{x, 0}, {x, y}}]; \[IndentingNewLine]Show[
          Graphics[{Line /@ bipuntos[k], puntitos[k]}], Axes \[Rule] True, 
          AxesLabel -> {"\<frecuencia\>", "\<amplitud\>"}, 
          Ticks \[Rule] {Transpose[{Range[0, k - 1]/k, 
                  Table[j - 1, {j, 1, k}]}], Automatic}, 
          PlotRange -> All];]\)}], "Input"],

Cell[BoxData[
    \(plotDFT[32]\)], "Input"],

Cell["\<\
Efectivamente, en la gr\[AAcute]fica anterior los \[UAcute]nicos coeficientes \
no nulos son los que corresponden a las frecuencias 1, 3, 4, 6, 12 y 15 que \
forman la se\[NTilde]al de partida. Observa c\[OAcute]mo los m\[OAcute]dulos \
de los coeficientes de la segunda mitad de la transformada (del 17 al 31) \
repiten los de la primera mitad (del 1 al 15) (simetr\[IAcute]a respecto del \
punto correspondiente a la frecuencia 16)   Observa tambi\[EAcute]n \
c\[OAcute]mo el valor de los coeficientes es la mitad de las amplitudes \
correspondientes a cada frecuencia. \
\>", "Text"],

Cell["\<\
Observa que si no tomamos suficientes puntos no podemos recuperar la se\
\[NTilde]al. Por ejemplo, si la muestra tiene tama\[NTilde]o 30 no aparece el \
t\[EAcute]rmino correspondiente a la frecuencia 15.\
\>", "Text"],

Cell[BoxData[
    \(plotDFT[30]\)], "Input"],

Cell["\<\
Un resultado b\[AAcute]sico en muestreo, el teorema de Shannon-Whittaker, \
afirma que se puede recuperar una se\[NTilde]al tomando en un per\[IAcute]odo \
un n\[UAcute]mero de muestras mayor que el doble de la m\[AAcute]xima \
frecuencia presente en dicha se\[NTilde]al. En el ejemplo anterior la m\
\[AAcute]xima frecuencia es 15 y hemos comprobado que con 32 muestras se \
recupera la se\[NTilde]al pero con 30 no se recupera dicha se\[NTilde]al sino \
que se recupera otra se\[NTilde]al en la que se ha perdido la frecuencia 15. \
\
\>", "Text"],

Cell[BoxData[{
    \(\(\(aliasf[t_] := 
        Sin[2  \[Pi]\ t] +  .5  Sin[3*2  \[Pi]\ t] + 
          Cos[4*2  \[Pi]\ t] +  .5  Cos[6*2  \[Pi]\ t] + 
          2  Cos[12*2  \[Pi]\ t];\)\(\[IndentingNewLine]\)
    \) (*\ hemos\ quitado\ la\ frecuencia\ 15\ en\ la\ funci\[OAcute]n\ f[
          t]\ *) \), "\[IndentingNewLine]", 
    \(\(Plot[{f[t], aliasf[t]}, {t, 0, 1}, 
        PlotStyle \[Rule] {RGBColor[0, 1, 0], RGBColor[0, 0, 1]}, 
        Epilog \[Rule] {PointSize[0.015], Hue[1], 
            Point /@ Transpose[{Range[0, 29]/30, 
                  f[Range[0, 29]/30]}]}];\)\)}], "Input"],

Cell["\<\
En la gr\[AAcute]fica anterior (ampl\[IAcute]ala para verla bien) puedes \
apreciar c\[OAcute]mo la se\[NTilde]al recuperada (en azul) y la \
se\[NTilde]al original (en verde) coinciden en los puntos de la muestra. Se \
dice que la se\[NTilde]al recuperada enmascara la se\[NTilde]al original: es \
un \"alias\" de ella. El t\[EAcute]rmino ingl\[EAcute]s para este hecho es \
\"aliasing\".\
\>", "Text"],

Cell["\<\
Finalmente, veamos lo que ocurre si tomamos muestras igualmente espaciadas a \
lo largo de dos per\[IAcute]odos.\
\>", "Text"],

Cell[BoxData[
    RowBox[{
      RowBox[{"ListPlot", "[", 
        RowBox[{
          RowBox[{
            RowBox[{"Transpose", "[", 
              RowBox[{"{", 
                RowBox[{\(Range[0, 63]\), ",", 
                  RowBox[{"Chop", "[", 
                    RowBox[{"Abs", "[", 
                      RowBox[{"DFT", "[", 
                        
                        StyleBox[\(Join[f[Range[0, 31]/32], 
                            f[Range[0, 31]/32]]\),
                          FontColor->RGBColor[1, 0, 0]], "]"}], "]"}], 
                    "]"}]}], "}"}], "]"}], 
            "/.", \({x_, y_?Positive} \[Rule] 
              Sequence[{x, 0}, {x, y}, {x, 0}]\)}], 
          ",", \(PlotJoined \[Rule] True\), 
          ",", \(Ticks \[Rule] {Table[k, {k, 0, 63, 2}], Automatic}\), 
          ",", \(Epilog \[Rule] {PointSize[0.015], Hue[1], 
              Point /@ Transpose[{Range[0, 63], 
                    Chop[Abs[
                        DFT[Join[f[Range[0, 31]/32], 
                            f[Range[0, 31]/32]]]]]}]}\)}], "]"}], 
      ";"}]], "Input"],

Cell[TextData[{
  "Compara esta gr\[AAcute]fica con la gr\[AAcute]fica anterior plotDFT[32]. \
Lo que ha ocurrido es lo siguiente: como las frecuencias en la DFT son \
relativas al tama\[NTilde]o de la muestra, al multiplicar por dos la longitud \
de la muestra pasando de ",
  Cell[BoxData[
      \(TraditionalForm\`N = 32\)]],
  " a ",
  Cell[BoxData[
      \(TraditionalForm\`N = 64\)]],
  " puntos, los \[IAcute]ndices ",
  Cell[BoxData[
      \(TraditionalForm\`k\)]],
  " correspondientes a las frecuencias presentes en la muestra \
tambi\[EAcute]n quedan multiplicados por dos. Este detalle lo tendremos en \
cuenta m\[AAcute]s adelante cuando dise\[NTilde]emos un filtro."
}], "Text"],

Cell[TextData[{
  "Podemos comparar los coeficientes de Fourier ",
  Cell[BoxData[
      \(TraditionalForm\`c\_n\)]],
  " con su aproximaci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`Y\_n\)]],
  ". Por la forma en que se calcularon los ",
  Cell[BoxData[
      \(TraditionalForm\`Y\_n\)]],
  " esperamos que se tenga ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\ \)\(c\_n \[TildeEqual] Y\_n\)\)\)]],
  " para ",
  Cell[BoxData[
      \(TraditionalForm\`\(-N\)/2 \[LessEqual] n \[LessEqual] N/2 - 1\)]],
  ". En el siguiente ejercicio te pido que compruebes esto."
}], "Text"],

Cell[CellGroupData[{

Cell["Ejercicio 2", "Exercise"],

Cell[TextData[{
  "Considera la extensi\[OAcute]n 2\[Pi]-peri\[OAcute]dica de la funci\
\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`f[t] = t\ Sin[t]\)]],
  "  (",
  Cell[BoxData[
      \(TraditionalForm\`\(-\[Pi]\) \[LessEqual] t \[LessEqual] \[Pi]\)]],
  "). Pide a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " que construya una tabla de tres columnas con encabezados \"n\", \"c[n]\", \
\"Y[n]\"; donde n toma valores de 0 a 12; c[n] son los coeficientes de \
Fourier de ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  "; Y[n] son los valores de la transformada de Fourier discreta de una \
muestra de la extensi\[OAcute]n 2\[Pi]-peri\[OAcute]dica de ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " en ",
  Cell[BoxData[
      \(TraditionalForm\`N\)]],
  " puntos igualmente espaciados del intervalo ",
  Cell[BoxData[
      \(TraditionalForm\`\([0, 2  \[Pi]]\)\)]],
  ". Haz dos tablas correspondientes a ",
  Cell[BoxData[
      \(TraditionalForm\`N = 30\)]],
  " y a ",
  Cell[BoxData[
      \(TraditionalForm\`N = 100\)]],
  ". \nSugerencia: Puedes definir un comando que dependa de un \
par\[AAcute]metro ",
  Cell[BoxData[
      \(TraditionalForm\`k\)]],
  " y que d\[EAcute] como salida la tabla que se pide. El comando TableForm[] \
puede ser \[UAcute]til. Procura hacer los c\[AAcute]lculos de forma num\
\[EAcute]rica."
}], "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "DFT en ",
  StyleBox["Mathematica",
    FontSlant->"Italic"]
}], "Section"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " tiene un comando \"Fourier[lista]\" para calcular la DFT que usa el \
algoritmo de la Transformada R\[AAcute]pida de Fourier. Pero ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " define la DFT en la forma siguiente:\n\t\t\t\t",
  Cell[BoxData[
      \(TraditionalForm\`Y\_n = \(1\/\@N\) \(\[Sum]\+\(k = 1\)\%N\(\( 
                  y\_k\) \(\[ExponentialE]\^\(2\ \[ImaginaryI]\ \[Pi]\ \((n - 
                        1)\) \((\ k - 1)\)/
                      N\)\)\(\ \ \ \ \ \ \ \ \ \ \ \ \)\((n = 1, 2,  ... , 
                N)\)\(\ \)\)\)\)]],
  "\nes decir, divide por ",
  Cell[BoxData[
      \(TraditionalForm\`\@N\)]],
  "en vez de por ",
  StyleBox["N",
    FontSlant->"Italic"],
  " y conjuga las exponenciales. Para que el comando \"Fourier[lista]\" \
proporcione la DFT que hemos definido nosotros hay que ajustar unos par\
\[AAcute]metros (consulta la ayuda de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "). Ejecuta las siguientes celdas para entender la relaci\[OAcute]n entre \
nuestro comando DFT[ ] y Fourier[ ]."
}], "Text"],

Cell[BoxData[
    \(DFT[{1.  + 1.  I, 2. , 3. , 4. , 5. }]\)], "Input"],

Cell[BoxData[
    \(1/Sqrt[5. ] 
      RotateLeft[
        Reverse[Fourier[{1.  + I, 2. , 3. , 4. , 5. }]], \(-1\)]\)], "Input"],

Cell[BoxData[
    \(\(\(Fourier[{1.  + 1.  I, 2. , 3. , 4. , 5. }, 
      FourierParameters \[Rule] {\(-1\), \(-1\)}]\)\( (*\ 
      no\ funciona\ en\ la\ versi\[OAcute]n\ 3.0\ *) \)\)\)], "Input"],

Cell["\<\
No te debe caber duda de cu\[AAcute]l es el que hay que usar para hacer c\
\[AAcute]lculos.\
\>", "Text"],

Cell[BoxData[{
    \(Clear[lista]\), "\[IndentingNewLine]", 
    \(\(lista = Table[Random[], {1024}];\)\), "\[IndentingNewLine]", 
    \(\(Timing[
        Fourier[lista, 
          FourierParameters \[Rule] {\(-1\), \(-1\)}]]\)[\([1]\)]\  (*\ 
      visto\ y\ no\ visto\ *) \), "\[IndentingNewLine]", 
    \(\(Timing[DFT[lista]]\)[\([1]\)] (*\ espera\ un\ poco, \ 
      ten\ paciencia; \ 
      hay\ que\ hacer\ m\[AAcute]s\ de\ un\ mill\[OAcute]n\ de\ operaciones\ *) \
\)}], "Input"],

Cell[TextData[{
  "Ahora puedes apreciar el ahorro que proporciona el algoritmo de la \
transformada r\[AAcute]pida de Fourier. Pongamos a prueba el algoritmo con \
una muestra grande de ",
  Cell[BoxData[
      \(TraditionalForm\`2\^15 = 32678\)]],
  " datos. Solamente pretender almacenar la matriz de los \[Omega][n,N] para \
N=32678 ya ser\[IAcute]a un problema. "
}], "Text"],

Cell[BoxData[{
    \(Clear[lista]\), "\[IndentingNewLine]", 
    \(\(lista = Table[Random[], {32678}];\)\), "\[IndentingNewLine]", 
    \(\(Timing[
        Fourier[lista, 
          FourierParameters \[Rule] {\(-1\), \(-1\)}]]\)[\([1]\)]\), "\
\[IndentingNewLine]", 
    \(Clear[lista]\)}], "Input"],

Cell["No est\[AAcute] mal \[DownQuestion]verdad?.", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Transformada de Fourier Discreta y convoluci\[OAcute]n \
c\[IAcute]clica", "Section"],

Cell[TextData[{
  "Estudiemos ahora la relaci\[OAcute]n entre DFT y convoluci\[OAcute]n. \
Recuerda que, dados dos vectores ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["x",
            FontWeight->"Bold"], 
          "=", \((x\_0, x\_\(\(1\)\(,\)\) ... , x\_\(N - 1\))\)}], 
        TraditionalForm]]],
  " ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["y",
            FontWeight->"Bold"], 
          "=", \((y\_0, y\_\(\(1\)\(,\)\) ... , y\_\(N - 1\))\)}], 
        TraditionalForm]]],
  ", se define su convoluci\[OAcute]n circular o c\[IAcute]clica como el \
vector ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["z",
            FontWeight->"Bold"], "=", 
          RowBox[{
            StyleBox["x",
              FontWeight->"Bold"], 
            StyleBox[
              FormBox[\(\(\ \)\(\[CircleDot]\)\),
                "TraditionalForm"],
              FontWeight->"Bold"], 
            StyleBox[" ",
              FontWeight->"Bold"], 
            StyleBox["y",
              FontWeight->"Bold"]}]}], TraditionalForm]]],
  " dado por\n\n\t\t\t",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{"(", GridBox[{
                {\(z\_0\)},
                {\(z\_1\)},
                {\(z\_2\)},
                {"..."},
                {\(z\_\(N - 1\)\)}
                }], ")"}], "  "}], TraditionalForm]]],
  "=  ",
  Cell[BoxData[
      FormBox[
        RowBox[{"(", GridBox[{
              {\(y\_0\), \(y\_\(N - 1\)\), \(y\_\(N - 2\)\), \(y\_\(N - 3\)\),
                 "...", "...", "...", "...", \(y\_1\)},
              {\(y\_1\), \(y\_0\), \(y\_\(N - 1\)\), \(y\_\(N - 2\)\), "...", 
                "...", "...", "...", \(y\_2\)},
              {\(y\_2\), \(y\_1\), \(y\_0\), \(y\_\(N - 1\)\), "...", "...", "...",
                 "...", \(y\_3\)},
              {"...", "...", "...", "...", "...", "...", "...", "...", 
                "..."},
              {\(y\_\(N - 1\)\), \(y\_\(N - 2\)\), \(y\_\(N - 
                      3\)\), \(y\_\(N - 4\)\), "...", "...", "...", 
                "...", \(y\_0\)}
              }], ")"}], TraditionalForm]]],
  Cell[BoxData[
      FormBox[
        RowBox[{"(", GridBox[{
              {\(x\_0\)},
              {\(x\_1\)},
              {\(x\_2\)},
              {"..."},
              {\(x\_\(N - 1\)\)}
              }], ")"}], TraditionalForm]]],
  "\n\t\t\t"
}], "Text"],

Cell[TextData[{
  "Las matrices como la anterior se llaman ",
  StyleBox["matrices circulantes",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell["Ejercicio 3", "Exercise"],

Cell[TextData[{
  "a) Define un comando \"CirculantMatrix[lista]\" que construye una matriz \
circulante a partir de una lista dada. Usa para ello los comandos Transpose[ \
], RotateRight[ ], NestList[ ].\nb) Usando el comando anterior, define un \
comando \"CiclicConvolve[x,y]\" que calcule la convoluci\[OAcute]n \
c\[IAcute]clica ",
  Cell[BoxData[
      FormBox[
        StyleBox[
          RowBox[{"x", 
            FormBox["\[CircleDot]",
              "TraditionalForm"], " ", "y"}],
          FontWeight->"Bold"], TraditionalForm]]],
  ".\nc) Comprueba simb\[OAcute]licamente para listas de 4 elementos que",
  Cell[BoxData[
      FormBox[
        StyleBox[
          RowBox[{" ", 
            RowBox[{
              FormBox[
                StyleBox[
                  RowBox[{"x", 
                    FormBox["\[CircleDot]",
                      "TraditionalForm"], " ", "y"}],
                  FontWeight->"Bold"],
                "TraditionalForm"], "=", \(y\[CircleDot]x\)}]}],
          FontWeight->"Bold"], TraditionalForm]]],
  ".\nd) Comprueba simb\[OAcute]licamente para listas de N=4 elementos que ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(DFT[x\[CircleDot]\ y] = N\ DFT[x]\ DFT[y]\),
          FontWeight->"Bold"], TraditionalForm]]],
  "."
}], "ExerciseText"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " dispone de un comando \"ListConvolve[n\[UAcute]cleo,lista]\" (consulta la \
ayuda de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ") que con un ajuste de par\[AAcute]metros permite calcular convoluciones c\
\[IAcute]clicas (aunque el comando de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " es mucho m\[AAcute]s general)."
}], "Text"],

Cell[BoxData[
    \(ListConvolve[{a, b, c}, {x, y, z}, 1]\)], "Input"],

Cell[TextData[{
  "\t    e) Comprueba con listas ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(x\)\(,\)\(y\)\(\ \)\)\)]],
  "generadas aleatoriamente de 1024 elementos cada una que "
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`Fourier[ListConvolve[x, y, 1]] == \(\@1024\) 
        Fourier[x]\ *\ Fourier[y]\)], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Advertencia: debido a los errores de redondeo lo que puedes comprobar es \
que ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{"Chop", "[", 
            
            FormBox[\(Fourier[ListConvolve[x, y, 1]] - \(\@1024\) 
                  Fourier[x]\ *\ Fourier[y]\),
              "TraditionalForm"], "]"}], "==", \(Table[0. , {1024}]\)}], 
        TraditionalForm]]]
}], "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Con ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " puedes o\[IAcute]r las funciones"
}], "Section"],

Cell[TextData[{
  "En esta secci\[OAcute]n te voy a presentar algunos comandos y herramientas \
de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " que son \[UAcute]tiles para trabajar con se\[NTilde]ales de sonido. \
Comprobar\[AAcute]s que ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " trata el sonido de forma parecida a las representaciones \
gr\[AAcute]ficas. No voy a proponerte ejercicios en esta secci\[OAcute]n."
}], "Text"],

Cell["El comando ListPlay[ ]", "Definition"],

Cell["\<\
La sintaxis de este comando es (igual que ListPlot[ ])  \
ListPlay[lista,opciones] donde \"lista\" puede ser cualquier lista de n\
\[UAcute]meros reales. Cuando un sonido es reproducido los valores de la \
lista son convertidos en voltajes que se aplican al altavoz para producir el \
sonido. Una opci\[OAcute]n importante es \"SampleRate\", por defecto igual a \
8192 (aunque puede variar de un ordenador a otro),  que indica el \
n\[UAcute]mero de valores que ser\[AAcute]n convertidos por segundo para \
reproducir el sonido. Otra opci\[OAcute]n es \"PlayRange\" que debe ajustarse \
dependiendo de la magnitud de los datos (la cual depende de la codificaci\
\[OAcute]n que se haya hecho de los mismos: 8 bits o 16 bits son las \
ususales). Aqu\[IAcute] tienes algunos ejemplos. Para reproducir el sonido en \
una celda Output de sonido la seleccionas con el rat\[OAcute]n y pulsas \
Alt+c+p (si haces doble click el sonido se reproduce continuamente).\
\>", "Text"],

Cell[BoxData[
    \(\(\(ListPlay[First[RealDigits[N[1\/97, 1000]]]]\)\( (*\ 
      o\[IAcute]mos\ los\ primeros\ 1000\ d\[IAcute]gitos\ de\ la\ \
representaci\[OAcute]n\ decimal\ 1/
          97. \ Como\ se\ trata\ de\ un\ n\[UAcute]mero\ racional\ la\ lista\ \
tiene\ un\ per\[IAcute]odo\ que\ se\ repite\ y\ esa\ regularidad\ se\ refleja\
\ en\ el\ sonido\ *) \)\)\)], "Input"],

Cell[BoxData[
    \(\(\(ListPlay[First[RealDigits[N[\[Pi], 1000]]]]\)\( (*\ 
      el\ n\[UAcute]mero\ \[Pi]\ no\ es\ racional\ y\ la\ sucesi\[OAcute]n\ \
de\ sus\ d\[IAcute]gitos\ decimales\ no\ tiene\ ninguna\ regularidad\ lo\ que\
\ se\ refleja\ en\ el\ sonido\ que\ se\ oye\ *) \)\)\)], "Input"],

Cell["\<\
Ahora puedes escuchar la aplicaci\[OAcute]n log\[IAcute]stica que usamos en \
la pr\[AAcute]ctica de iteraci\[OAcute]n y caos.\
\>", "Text"],

Cell[BoxData[{
    \(\(logistic[n_Integer] := 
        Module[{f, t, x}, \[IndentingNewLine]f = 
            Compile[{x, t}, Evaluate[\((3 + t\/n)\)\ x\ \((1 - x)\)]]; 
          FoldList[f, 0.223, Range[n]]];\)\), "\[IndentingNewLine]", 
    \(\(\(ListPlay[logistic[8000], SampleRate \[Rule] 2000]\)\(;\)\( (*\ 
      observa\ c\[OAcute]mo\ el\ sonido\ al\ principio\ es\ claro\ y\ n\
\[IAcute]tido\ y\ despu\[EAcute]s\ degenera\ en\ un\ ruido\ *) \)\)\)}], \
"Input"],

Cell[BoxData[
    \(ListPlay[Table[Sin[2\ \[Pi]\ 400. \ t], {t, 0, 1, 1/8000}]]\)], "Input"],

Cell["El comando Play[ ]", "Definition"],

Cell["\<\
La sintaxis de este comando es (igual que la de Plot[ ]) \
Play[funci\[OAcute]n,{t,min,max},opciones] y reproduce un sonido cuya \
amplitud est\[AAcute] dada por la funci\[OAcute]n en el tiempo en segundos \
comprendido entre \"min\" y \"max\". Adem\[AAcute]s de las opciones antes se\
\[NTilde]aladas para ListPlay[ ], v\[AAcute]lidas tambi\[EAcute]n para Play[ \
], hay otra opci\[OAcute]n interesante que es \"SampleDepth\", por defecto \
igual a 8, que indica el n\[UAcute]mero de bits que deben usarse para \
codificar los datos. Play[{funcion1,funcion2},{t,min,max},opciones] reproduce \
en est\[EAcute]reo. Ten en cuenta que el convertidor \
digital-anal\[OAcute]gico de la tarjeta de sonido de tu ordenador puede no \
soportar bien algunas tasas de muestreo lo que puede producir disonancias.\
\>", "Text"],

Cell[BoxData[
    \(Play[Sin[2\ \[Pi]\ 440\ t], {t, 0, 1}]\)], "Input"],

Cell[BoxData[
    \(\(\(Play[Sin[2\ \[Pi]\ 440\ t], {t, 0, 1}, 
      SampleDepth \[Rule] 4]\)\( (*\ 
      observa\ la\ p\[EAcute]rdida\ de\ calidad\ en\ el\ sonido\ *) \)\)\)], \
"Input"],

Cell[BoxData[
    \(\(\(Play[Sin[2\ \[Pi]\ 6000\ t], {t, 0, 1}]\)\(;\)\( (*\ 
      la\ raz\[OAcute]n\ de\ muestreo\ por\ defecto\ es\ muy\ baja\ para\ \
reproducir\ bien\ esta\ funci\[OAcute]n\ cuya\ frecuencia\ es\ muy\ alta\ y\ \
queda\ enmascarada\ por\ otra\ m\[AAcute]s\ baja\ *) \)\)\)], "Input"],

Cell[BoxData[
    \(\(\(Play[Sin[2\ \[Pi]\ 6000\ t], {t, 0, 1}, 
      SampleRate \[Rule] 12400]\)\( (*\ 
      usamos\ una\ raz\[OAcute]n\ de\ muestreo\ mayor\ que\ el\ doble\ de\ la\
\ frecuencia; \ ahora\ el\ sonido\ es\ m\[AAcute]s\ agudo\ *) \)\)\)], "Input"],

Cell["\<\
El siguiente comando se debe a Theodore Gray y reproduce una sucesi\[OAcute]n \
de sonidos sin interrupci\[OAcute]n entre ellos.\
\>", "Text"],

Cell[BoxData[{
    \(\(Attributes[
          CombinedSoundShow] = {HoldFirst};\)\), "\[IndentingNewLine]", 
    \(CombinedSoundShow[list_] := 
      Block[{llist}, \[IndentingNewLine]Block[{$DisplayFunction = 
              Identity, \ $SoundDisplayFunction = 
              Identity}, \[IndentingNewLine]\(llist = 
              list;\)]; \[IndentingNewLine]Show[
          Sound[Map[First, llist]]]]\)}], "Input"],

Cell[BoxData[
    \(CombinedSoundShow[{Play[Sin[2\ \[Pi]\ 440\ t], {t, 0, 0.25}], 
        Play[Sin[2\ \[Pi]\ 550\ t], {t, 0, 0.5}], 
        Play[Sin[2\ \[Pi]\ 880\ t], {t, 0,  .25}]}]\)], "Input"],

Cell["\<\
Finalmente, aqu\[IAcute] tienes un sonido estereof\[OAcute]nico (si dispones \
de altavoces apropiados).\
\>", "Text"],

Cell[BoxData[
    \(Play[{Sin[2\ \[Pi]\ 440\ t], Sin[2\ \[Pi]\ 822\ t]}, {t, 0, 
        1}]\)], "Input"],

Cell["\<\
Primitivas de sonido SampledSoundList[ ] y SampledSoundFunction[ ]\
\>", "Definition"],

Cell["\<\
De la misma manera que ListPlot[ ] y Plot[ ] dan como salida un objeto \
\"Graphics\", habr\[AAcute]s observado que la salida de los comandos \
PlayList[ ] y Play[ ] es un objeto \"Sound\".  An\[AAcute]logamente a \
\"Graphics\", un objeto \"Sound\" contiene una lista de primitivas de sonido \
que pueden reproducirse con Show[ ]. \
\>", "Text"],

Cell[BoxData[
    \(InputForm[ListPlay[Table[Tan[n], {n, 1, 25}]]]\)], "Input"],

Cell["\<\
Como puedes ver lo que hace el comando ListPlay[ ] es convertir los datos de \
la lista a n\[UAcute]meros reales comprendidos entre -1 y 1, pasar estos \
datos a la primitiva de sonido \"SampledSoundList\" y reproducirla con \
Show[Sound[SampledSoundList[ ]] ] ]. El objeto \"SampledSoundList\" es de la \
forma  \"SampledSoundList[lista,srate]\" su primer argumento es una lista de \
n\[UAcute]meros reales comprendidos entre -1 y 1 y su segundo argumento es la \
raz\[OAcute]n de muestreo, el n\[UAcute]mero de muestras que se convierten \
cada segundo para producir el sonido. \
\>", "Text"],

Cell[BoxData[
    \(InputForm[Play[Sin[2\ \[Pi]\ 440\ \ x], {x, 0,  .5}]]\)], "Input"],

Cell[TextData[{
  "El objeto \"Sound\" que devuelve Play[ ] contiene como \[UAcute]nico \
elemento una primitiva de sonido que es \"SampledSoundFunction\" la cual se \
encarga de hacer, cada vez que se reproduce el sonido, la lista \
correspondiente de datos por medio de una funci\[OAcute]n compilada. Es m\
\[AAcute]s c\[OAcute]moda para trabajar la primitiva \"SampledSoundList\" \
que, aunque ocupa m\[AAcute]s memoria, contiene la lista de datos como parte \
de ella lo que permite usar los comandos propios de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " para trabajar con listas. Por ejemplo, es inmediato revertir un sonido \
con el comando \"Reverse[ ]\" o extraer parte de \[EAcute]l o realizar un \
filtrado como veremos a continuaci\[OAcute]n."
}], "Text"],

Cell["\<\
El siguiente comando convierte un objeto \"SampledSoundFunction\" en \
\"SampledSoundList\".\
\>", "Text"],

Cell[BoxData[
    \(FunctionToList[
        sound_SampledSoundFunction] := \[IndentingNewLine]Module[{samps}, \
\[IndentingNewLine]samps = 
          Array[sound[\([1]\)], 
            sound[\([2]\)]]; \[IndentingNewLine]samps /= \((Max[Abs[samps]] + 
              0.00001)\); \[IndentingNewLine]Return[
          SampledSoundList[samps, sound[\([3]\)]]]]\)], "Input"],

Cell[BoxData[
    \(\(sinf = 
        Play[Sin[2\ \[Pi]\ 1000\ t], {t, 0,  .05}, 
          SampleRate \[Rule] 22050];\)\)], "Input"],

Cell[BoxData[{
    \(\(sinl = FunctionToList[sinf[\([1]\)]];\)\), "\[IndentingNewLine]", 
    \(\(Show[Sound[sinl]];\)\)}], "Input"],

Cell["Ciertamente que esto se puede hacer directamente.", "Text"],

Cell[BoxData[{
    \(\(tresenos = 
        SampledSoundList[
          Table[N[0.3 \((Sin[2\ \[Pi]\ 400\ x] + Sin[2\ \[Pi]\ 800\ x] + \ 
                    Sin[2\ \[Pi]\ 1600\ x])\)], {x, 0, 0.25, 1/22050}], 
          22050];\)\), "\[IndentingNewLine]", 
    \(\(Show[Sound[tresenos]];\)\)}], "Input"],

Cell[BoxData[
    \(\(CombinedSoundShow[{Sound[FunctionToList[sinf[\([1]\)]]], 
          Sound[tresenos], 
          Sound[FunctionToList[sinf[\([1]\)]]]}];\)\)], "Input"],

Cell[BoxData[
    \(Clear[sinf, sinl, tresenos]\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Trabajar con archivos de sonido", "Section"],

Cell[TextData[{
  "Puedes importar archivos de sonido con el comando \
Import[\"C:/archivo.ext\"] (debes dar la ruta completa del archivo o bien \
decir a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " que trabaje en la carpeta donde est\[AAcute] el archivo lo que se hace \
con SetDirectory[ ]). Con esta pr\[AAcute]ctica habr\[AAcute]s bajado el \
archivo pavrti.wav. Antes de seguir establece el directorio de trabajo."
}], "Text"],

Cell[BoxData[
    \(SetDirectory["\<especifica aqu\[IAcute] la ruta al directorio que \
contiene el archivo pavrti.wav\>"]\)], "Input"],

Cell[BoxData[
    \(\(\(nesdorma = 
      Import["\<pavrti.wav\>"]\)\(;\)\( (*\ \[DownExclamation]no\ quites\ el\ \
; ! \ *) \)\)\)], "Input"],

Cell[TextData[{
  "Puedes ver la forma en que ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " representa el archivo importado como un objeto de sonido \"Sound\" que \
consta de una \[UAcute]nica primitiva \"SampledSoundList\"."
}], "Text"],

Cell[BoxData[
    \(\(\(Short[InputForm[nesdorma]]\)\( (*\ 
      observa\ que\ la\ tasa\ de\ muestreo\ es\ 8000\ *) \)\)\)], "Input"],

Cell["\<\
La lista de datos es el primer argumento de \"SampledSoundList\", es decir \
nesdorma[[1,1]]. Es demasiado grande para sacarlo en pantalla.\
\>", "Text"],

Cell[BoxData[
    \(Length[nesdorma[\([1, 1]\)]]\)], "Input"],

Cell["Pero podemos representarlo gr\[AAcute]ficamente con ListPlot[ ].", \
"Text"],

Cell[BoxData[
    \(\(ListPlot[nesdorma[\([1, 1]\)], PlotRange \[Rule] All];\)\)], "Input"],

Cell["\<\
Como ves son datos comprendidos entre -1 y 1 y su aspecto resulta familiar; \
recuerda las im\[AAcute]genes que salen en la grabadora de sonidos de \
Windows. Podemos reproducir el archivo.\
\>", "Text"],

Cell[BoxData[
    \(\(ListPlay[nesdorma[\([1, 1]\)]];\)\)], "Input"],

Cell["Tambi\[EAcute]n pdemos hacerlo directamente.", "Text"],

Cell[BoxData[
    \(\(Show[nesdorma];\)\)], "Input"],

Cell["\[DownQuestion]Tienes curiosidad por escucharlo de atr\[AAcute]s \
adelante?", "Text"],

Cell[BoxData[
    \(\(ListPlay[Reverse[nesdorma[\([1, 1]\)]]];\)\)], "Input"],

Cell["\[DownQuestion]C\[OAcute]mo sonar\[AAcute] el cuadrado de \
\"nesdorma\"?", "Text"],

Cell[BoxData[
    \(\(ListPlay[nesdorma[\([1, 1]\)]^2];\)\)], "Input"],

Cell[TextData[{
  "Pues suena bastante mal. Pero lo ya visto muestra las muchas posibilidades \
para trabajar con archivos de sonido. ",
  StyleBox["Mathematica ",
    FontSlant->"Italic"],
  "tiene un paquete que es bastante \[UAcute]til para obtener informaci\
\[OAcute]n adicional de un archivo de sonido (al menos a partir de la versi\
\[OAcute]n 5, no s\[EAcute] si antes estaba  disponible). "
}], "Text"],

Cell["<< Miscellaneous`Audio`", "Input",
  CellTags->"S5.51.1"],

Cell[TextData[{
  "Este paquete carga, entre otros, el comando \
\"ReadSoundFile[\"archivo.ext\", PrintHeader",
  Cell[BoxData[
      \(TraditionalForm\` -> \)]],
  "True]\" que lee el archivo de sonido especificado y lo convierte en una \
lista de enteros comprendidos entre -32768 y +32767 (codificaci\[OAcute]n de \
16 bits). Adem\[AAcute]s, y esto es lo interesante, proporciona la informaci\
\[OAcute]n contenida en la cabecera del archivo."
}], "Text"],

Cell[BoxData[
    \(\(\(nessund = 
      ReadSoundFile["\<pavrti.wav\>", 
        PrintHeader \[Rule] 
          True]\)\(;\)\( (*\ \[DownExclamation]no\ quites\ el\ ; ! \ *) \
\)\)\)], "Input"],

Cell[TextData[{
  "El archivo importado lo representa ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " simplemente como una lista sin m\[AAcute]s informaci\[OAcute]n \
adicional."
}], "Text"],

Cell[BoxData[
    \(Head[nessund]\)], "Input"],

Cell[BoxData[
    \(Length[nessund]\)], "Input"],

Cell[BoxData[
    \(\(ListPlot[nessund, PlotRange \[Rule] All];\)\)], "Input"],

Cell[BoxData[
    \(\(ListPlay[Take[nessund, 25000]];\)\)], "Input"],

Cell[TextData[{
  "Podemos exportar archivos de sonido en varios formatos con el comando \
\"Export[\"archivo.ext\",expr]\". Este comando est\[AAcute] disponible a \
partir de la versi\[OAcute]n 4 de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". Dependiendo del tipo de conversi\[OAcute]n de datos que se haga se puede \
perder bastante calidad en el sonido."
}], "Text"],

Cell[BoxData[
    RowBox[{
      TagBox[
        FrameBox[\(Export["\<nes.wav\>", 
            Sound[SampledSoundList[Take[nesdorma[\([1, 1]\)], 25000], 
                8000]]]\),
          BoxFrame->False,
          BoxMargins->False],
        Short], ";", \( (*\ no\ se\ pierde\ calidad\ *) \)}]], "Input"],

Cell[BoxData[
    RowBox[{
      TagBox[
        FrameBox[\(Export["\<nes2.wav\>", 
            Sound[SampledSoundList[N[Take[nessund, 25000]/32768], 8000]]]\),
          BoxFrame->False,
          BoxMargins->False],
        Short], \( (*\ 
        si\ no\ tienes\ la\ precauci\[OAcute]n\ de\ dividir\ por\ 32768\ para\
\ situar\ los\ datos\ en\ el\ intervalo\ [\(-1\), 1], \ 
        el\ archivo\ que\ resulta\ pierde\ mucha\ calidad\ de\ sonido\ *) \
\)}]], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Filtrado de se\[NTilde]ales de sonido", "Section"],

Cell[TextData[{
  "Sabemos que los filtros (sistemas lineales invariantes en el tiempo y \
continuos)  act\[UAcute]an por convoluci\[OAcute]n. Te lo recuerdo \
brevemente. Si ",
  Cell[BoxData[
      \(TraditionalForm\`L\)]],
  " es un filtro y \[Delta] es la funci\[OAcute]n impulso unidad discreta, \
esto es, ",
  Cell[BoxData[
      \(TraditionalForm\`\[Delta](n) = 0\)]],
  " para ",
  Cell[BoxData[
      \(TraditionalForm\`n \[NotEqual] \ 0\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`\[Delta](0) = 1\)]],
  "; se llama respuesta impulso del filtro a la se\[NTilde]al ",
  Cell[BoxData[
      \(TraditionalForm\`h(n) = L(\[Delta](n))\)]],
  ". Si ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["x",
            FontWeight->"Bold"], "=", \(x(n)\)}], TraditionalForm]]],
  " es una se\[NTilde]al cualquiera tenemos que:"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"L", "(", 
          StyleBox["x",
            FontWeight->"Bold"], 
          StyleBox[")",
            FontWeight->"Plain"]}], 
        StyleBox["=",
          FontWeight->"Plain"], 
        RowBox[{
          RowBox[{
            StyleBox["L",
              FontWeight->"Plain"], 
            StyleBox["(",
              
              FontWeight->
                "Plain"], \(\[Sum]\+\(k = \(-\[Infinity]\)\)\%\[Infinity]\( x(
                  k)\) \(\[Delta](n - k)\)\), ")"}], 
          "=", \(\[Sum]\+\(k = \(-\[Infinity]\)\)\%\[Infinity]\( x(
                  k)\) \(L(\[Delta](
                    n - k))\) = \[Sum]\+\(k = \(-\[Infinity]\)\)\%\[Infinity]\
\( x(k)\) \(h(n - k)\)\)}]}], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "La convoluci\[OAcute]n de dos se\[NTilde]ales discretas ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(x, \ y\),
          FontWeight->"Bold"], TraditionalForm]]],
  " se define como la se\[NTilde]al ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(x\[Star]y\),
          FontWeight->"Bold"], TraditionalForm]]],
  " dada para todo ",
  Cell[BoxData[
      \(TraditionalForm\`n \[Element] \[DoubleStruckZ]\)]],
  " por "
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          StyleBox["x",
            FontWeight->"Bold"], 
          StyleBox["\[Star]",
            FontWeight->"Bold"], \(y(n)\)}], 
        "=", \(\[Sum]\+\(k = \(-\[Infinity]\)\)\%\[Infinity]\( x(k)\) \(y(
              n - k)\)\)}], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Por tanto, la respuesta de un filtro a una se\[NTilde]al ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["x",
            FontWeight->"Bold"], 
          StyleBox["=",
            FontWeight->"Plain"], 
          StyleBox[\(x(n)\),
            FontWeight->"Plain"]}], TraditionalForm]]],
  " se obtiene por convoluci\[OAcute]n de dicha se\[NTilde]al con la \
respuesta impulso del filtro ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["h",
            FontWeight->"Bold"], "=", \(h \((n)\)\)}], TraditionalForm]]],
  ". Si, adem\[AAcute]s el filtro es ",
  StyleBox["causal",
    FontSlant->"Italic"],
  ", es decir, la salida del sistema en cualquier instante ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  " (esto es, ",
  Cell[BoxData[
      \(TraditionalForm\`y(n)\)]],
  ") depende s\[OAcute]lo de las entradas presentes y pasadas (es decir, ",
  Cell[BoxData[
      \(TraditionalForm\`x(n), \ x(n - 1), \ x(n - 2),  ... \)]],
  "), entonces debe ocurrir que ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(h(n)\)\(=\)\(0\)\(\ \)\)\)]],
  "para todo ",
  Cell[BoxData[
      \(TraditionalForm\`n < 0\)]],
  ". Si, adem\[AAcute]s, la funci\[OAcute]n respuesta impulso del filtro es \
de duraci\[OAcute]n finita, esto es, si ",
  Cell[BoxData[
      \(TraditionalForm\`h(n) = 0\)]],
  " para ",
  Cell[BoxData[
      \(TraditionalForm\`n \[GreaterEqual] M\)]],
  " entonces tenemos lo que se llama un filtro de respuesta impulso finita \
(FIR) causal. La acci\[OAcute]n de dicho filtro viene dada por"
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`y(
        n) = \[Sum]\+\(k = 0\)\%\(M - 1\)\(h(k)\) \(x(
            n - k)\)\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \((3)\)\)], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Llegados a este punto, una hip\[OAcute]tesis usual en tratamiento digital \
de se\[NTilde]ales es que la se\[NTilde]al de entrada ",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          RowBox[{
            StyleBox["x",
              FontWeight->"Bold"], "=", \(x \((n)\)\)}]}], 
        TraditionalForm]]],
  " tiene igual duraci\[OAcute]n finita que la respuesta impulso y que ambas \
se\[NTilde]ales son peri\[OAcute]dicas con per\[IAcute]odo ",
  Cell[BoxData[
      \(TraditionalForm\`M\)]],
  ". En estas hip\[OAcute]tesis (que comentaremos en la secci\[OAcute]n \
siguiente) la convoluci\[OAcute]n dada por (3) es de hecho ",
  StyleBox["una convoluci\[OAcute]n c\[IAcute]clica",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " de los vectores ",
  Cell[BoxData[
      \(TraditionalForm\`\((x(0), x(1), x(2),  ... , x(M - 1))\)\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`\((h(0), h(1), h(2),  ... , h(M - 1))\)\)]],
  ". Podemos por ello representar la acci\[OAcute]n del filtro en la forma ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["y",
            FontWeight->"Bold"], 
          StyleBox["=",
            FontWeight->"Bold"], 
          RowBox[{
            StyleBox["x",
              FontWeight->"Bold"], 
            StyleBox["\[CircleDot]",
              FontWeight->"Bold"], 
            StyleBox[" ",
              FontWeight->"Bold"], 
            StyleBox["h",
              FontWeight->"Bold"]}]}], TraditionalForm]]],
  "; tomando transformadas de Fourier discretas, como las que usa ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " por defecto, obtenemos, notando las correspondiente transformadas con \
letras may\[UAcute]sculas, ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(Y = \@M\ X\ H\),
          FontWeight->"Bold"], TraditionalForm]]],
  " donde el producto ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(X\ H\),
          FontWeight->"Bold"], TraditionalForm]]],
  " se entiende coordenada a coordenada. La se\[NTilde]al ",
  Cell[BoxData[
      FormBox[
        StyleBox["H",
          FontWeight->"Bold"], TraditionalForm]]],
  " se llama ",
  StyleBox["funci\[OAcute]n de transferencia",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " del filtro y es la DFT de la funci\[OAcute]n impulso respuesta. "
}], "Text"],

Cell[TextData[{
  "El dise\[NTilde]o de filtros en el dominio de la frecuencia consiste en \
definir una funci\[OAcute]n de transferencia que haga el trabajo deseado. Si, \
por ejemplo, queremos dejar pasar unas determinadas frecuencias sin alterar y \
eliminar las frecuencias restantes, nuestra funci\[OAcute]n de transferencia \
tendr\[AAcute] un 1 en los lugares correspondientes a las frecuencias que \
queremos dejar inalteradas y un 0 en los dem\[AAcute]s lugares; de esta forma \
el producto ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(X\ H\),
          FontWeight->"Bold"], TraditionalForm]]],
  " dejar\[AAcute] iguales los lugares (las componentes) de ",
  Cell[BoxData[
      FormBox[
        StyleBox["X",
          FontWeight->"Bold"], TraditionalForm]]],
  " correspondientes a las frecuencias que queremos dejar pasar inalteradas y \
en los dem\[AAcute]s lugares aparecer\[AAcute] un 0 eliminando de esa forma \
las frecuencias no deseadas. Una vez construida la funci\[OAcute]n de \
transferencia, la respuesta del filtro a una se\[NTilde]al ",
  Cell[BoxData[
      FormBox[
        StyleBox["x",
          FontWeight->"Bold"], TraditionalForm]]],
  " en el dominio del tiempo se obtiene calculando la DFT inversa de ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(\@M\ X\ H\),
          FontWeight->"Bold"], TraditionalForm]]],
  "; de hecho ",
  Cell[BoxData[
      FormBox[
        SqrtBox[
          StyleBox["N",
            FontWeight->"Bold"]], TraditionalForm]]],
  " es un factor de escala que suele ignorarse en la pr\[AAcute]ctica. \
Alternativamente, una vez obtenida ",
  Cell[BoxData[
      FormBox[
        StyleBox["H",
          FontWeight->"Bold"], TraditionalForm]]],
  " se puede obtener, por DFT inversa, la funci\[OAcute]n impulso respuesta \
",
  Cell[BoxData[
      FormBox[
        StyleBox["h",
          FontWeight->"Bold"], TraditionalForm]]],
  " y puede obtenerse la respuesta del filtro a una se\[NTilde]al de entrada \
",
  Cell[BoxData[
      FormBox[
        StyleBox["x",
          FontWeight->"Bold"], TraditionalForm]]],
  " ",
  "por medio de la convoluci\[OAcute]n c\[IAcute]clica ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(x\[CircleDot]\ h\),
          FontWeight->"Bold"], TraditionalForm]]],
  "; pero este m\[EAcute]todo es menos eficiente que el basado en la DFT que \
consiste en calcular ",
  Cell[BoxData[
      FormBox[
        StyleBox["X",
          FontWeight->"Bold"], TraditionalForm]]],
  ", multiplicar por ",
  Cell[BoxData[
      FormBox[
        StyleBox["H",
          FontWeight->"Bold"], TraditionalForm]]],
  " y por ",
  StyleBox[" ",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        StyleBox[\(\@M\),
          FontWeight->"Bold"], TraditionalForm]]],
  StyleBox[" ",
    FontWeight->"Bold"],
  "y tomar DFT inversa",
  StyleBox[". ",
    FontWeight->"Bold"],
  "En la pr\[AAcute]ctica se ignora",
  StyleBox[" ",
    FontWeight->"Bold"],
  "el factor de escala ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(\@M\),
          FontWeight->"Bold"], TraditionalForm]]],
  "; por ejemplo, si la se\[NTilde]al representa un sonido, multiplicarla por \
un n\[UAcute]mero positivo es algo que no se puede apreciar cuando se \
reproduce; adem\[AAcute]s la mayor\[IAcute]a de los formatos de sonido \
ajustan los valores a un intervalo prefijado.",
  StyleBox[" ",
    FontWeight->"Bold"]
}], "Text"],

Cell[CellGroupData[{

Cell["Ejercicio 4", "Exercise"],

Cell[TextData[{
  "En este ejercicio te propongo que dise\[NTilde]es un filtro de paso banda. \
Se trata de definir una funci\[OAcute]n \"filtropasobanda[sound_,fmin_,fmax_]\
\" donde se entiende que \"sound\" es la se\[NTilde]al de entrada y \
[fmin,fmax] es el intervalo de frecuencias que se van a dejar pasar \
inalteradas y las dem\[AAcute]s frecuencias se van a eliminar. Es importante \
en la se\[NTilde]al de entrada conocer la raz\[OAcute]n de muestreo (el n\
\[UAcute]mero de muestras por segundo) pues ello afecta de forma notable a la \
DFT; ya vimos antes que  las frecuencias en la DFT son relativas al tama\
\[NTilde]o de la muestra, al multiplicar por dos la longitud de la muestra \
pasando de ",
  Cell[BoxData[
      \(TraditionalForm\`N\)]],
  " a 2",
  Cell[BoxData[
      \(TraditionalForm\`N\)]],
  " puntos, los \[IAcute]ndices ",
  Cell[BoxData[
      \(TraditionalForm\`k\)]],
  " correspondientes a las frecuencias presentes en la muestra \
tambi\[EAcute]n quedan multiplicados por dos. En consecuencia habr\[AAcute] \
que ajustar \"fmin\" y \"fmax\" teniendo en cuenta el cociente \
longitud[muestra]/(srate). En vista de lo dicho, parece apropiado que \"sound\
\" sea de la forma sound=SoundSampledList[ ] pues as\[IAcute] tenemos todo \
junto: la lista de datos, que ser\[AAcute] sound[[1]], y la raz\[OAcute]n de \
muestreo, que ser\[AAcute] sound[[2]]. Adem\[AAcute]s es f\[AAcute]cil \
generar objetos de la forma \"SoundSampledList[ ]\"a los que podremos aplicar \
nuestro filtro.\nAparte de este detalle, hay otro aspecto t\[EAcute]cnico \
derivado del hecho de que la DFT (el algoritmo de la transformada \
r\[AAcute]pida de Fourier) trabaja mucho m\[AAcute]s r\[AAcute]pido con \
muestras cuyo tama\[NTilde]o es producto de n\[UAcute]meros primos peque\
\[NTilde]os (2, 3, 5). Por eso es conveniente poder ajustar el tama\[NTilde]o \
de la muestra a\[NTilde]adiendo ceros hasta lograr que tenga un \
tama\[NTilde]o \[OAcute]ptimo. \na) Define una lista ordenada de menor a \
mayor con todos los n\[UAcute]meros ",
  StyleBox["pares",
    FontSlant->"Italic"],
  " de la forma ",
  Cell[BoxData[
      \(TraditionalForm\`2\^i\ \(3\^j\) 5\^k\)]],
  "que sean menor o igual que ",
  Cell[BoxData[
      \(TraditionalForm\`32768 = 2\^15\)]],
  ". Llama a esa lista \"sizes\".\nb) Define una funci\[OAcute]n \
\"eligesize[z_]\" cuyo argumento es un n\[UAcute]mero (que ser\[AAcute] la \
longitud de la lista x[[1]]) que haga lo siguiente:\nSi ",
  Cell[BoxData[
      \(TraditionalForm\`z \[LessEqual] p = Max[sizes]\)]],
  ", entonces \"eligesize[z]\" proporciona el primer elemento de la lista \
\"sizes\" que es mayor o igual que ",
  Cell[BoxData[
      \(TraditionalForm\`z\)]],
  ".\nSi ",
  Cell[BoxData[
      \(TraditionalForm\`z > p\)]],
  ", se calcula el entero positivo ",
  Cell[BoxData[
      \(TraditionalForm\`q\)]],
  " m\[AAcute]s peque\[NTilde]o tal que ",
  Cell[BoxData[
      \(TraditionalForm\`z/2\^q \[LessEqual] p\)]],
  " y \"eligesize[z]\" es igual a ",
  Cell[BoxData[
      \(TraditionalForm\`2\^q\)]],
  " multiplicado por el primer elemento de \"sizes\" que es mayor o igual que \
",
  Cell[BoxData[
      \(TraditionalForm\`z/2\^q\)]],
  ".\nSugerencias: Esta funci\[OAcute]n es bien f\[AAcute]cil de definir. Los \
comandos \"Ceiling[ ]\", \"First[ ]\", \"Select[ ]\" pueden ser \
\[UAcute]tiles.\nc) Define la funci\[OAcute]n \
\"filtropasobanda[sound_SampledSoundList,fmin_,fmax_]\" que debe \
proporcionarte como salida otro objeto \"SampledSoundList[ ]\". Sigue los \
siguientes pasos:\nc1) Define variables locales: \"muestras=sound[[1]]\", \
\"srate=sound[[2]]\", \"newsize\", \"transfer\", \"newfmin\", \
\"newfmax\",\"origsize=Length[sound[[1]]]\", n.\nc2) Optimiza el \
tama\[NTilde]o de la lista \"muestras\" con \"newsize=2*eligesize[]\" (No es \
imprescindible multiplicar por 2 pero el resultado del filtro me ha parecido \
mejor as\[IAcute]. Ver Nota en la siguiente secci\[OAcute]n).\nc3) Agrega \
ceros al final de la lista \"muestras\" hasta que la longitud sea igual a \
\"newsize\". A la nueva lista obtenida le sigues llamando \"muestras\".\nc4) \
Define \"newfmin\" y \"newfmax\" teniendo en cuenta los valores \"fmin\" y \
\"fmax\" el tama\[NTilde]o \"newsize\" y \"srate\".\nc5) Define la funci\
\[OAcute]n de transferencia \"transfer\" que debe ser una lista de longitud \
\"newsize\" con elementos igual a 1 en los lugares ",
  Cell[BoxData[
      \(TraditionalForm\`newfmin \[LessEqual] \ n \[LessEqual] newfmax\)]],
  " y 0 en los restantes. Ten en cuenta que la funci\[OAcute]n de \
transferencia debe ser \"par\" para que pueda actuar de forma apropiada sobre \
la DFT de \"muestras\". Ten en cuenta que la mayor frecuencia presente es \
\"newsize/2+1\" (recuerda que \"newsize\" siempre es par). La idea es definir \
\"transfer\" para valores de ",
  Cell[BoxData[
      \(TraditionalForm\`n \[LessEqual] \ newsize/2 + 1\)]],
  " y simetrizar de forma adecuada. Pueden ser de utilidad los comandos \
\"Join[ ]\" (usado con cuidado), \"Take[ ]\", \"Reverse[ ]\". O \
quiz\[AAcute]s puedas usar el comando \"par[x]\" que has definido antes.\nc6) \
El trabajo que queda lo har\[AAcute] el algoritmo de la transformadad r\
\[AAcute]pida de Fourier. Se trata de obtener en el dominio del tiempo la se\
\[NTilde]al que devuelve el filtro. Esta se\[NTilde]al vamos a llamarla tambi\
\[EAcute]n \"muestras\" y viene dada como ya hemos explicado arriba. Hay un \
detalle y es que debes tomar de la se\[NTilde]al resultante los primeros \
\"origsize\" elementos. Y otro detalle: usa \"Chop[ ]\" y toma parte real \
\"Re[ ]\" para evitar errores de redondeo.\nc7) Un \[UAcute]ltimo detalle: \
asegurarnos de que los datos devueltos est\[AAcute]n comprendidos entre -1 y \
1 (podr\[IAcute]a haber sucedido algo raro debido a errores de redondeo). \
Para ello basta poner \"muestras /= Max[Abs[muestras]]\".\nc8) El \
\[UAcute]ltimo paso es construir el objeto \"SampledSoundList[ ]\" que \
devuelve nuestra funci\[OAcute]n. Te lo digo yo. Basta escribir \
Return[SampledSoundList[muestras,srate]]. \nEso es todo. Es much\[IAcute]simo \
m\[AAcute]s largo y m\[AAcute]s dif\[IAcute]cil, explicarlo que hacerlo."
}], "ExerciseText"],

Cell["Prueba el filtro que has definido con la siguiente muestra.", "Text"],

Cell[BoxData[
    \(\(senos = 
        SampledSoundList[
          Table[N[0.3\ \((Sin[2\ Pi\ 400. \ x] + Sin[2\ Pi\ 1600. \ x] + 
                    Sin[2\ Pi\ 3600. \ x])\)], {x, 0, 1 - 1/22500.0, 
              1/22500.0}], 22500];\)\)], "Input"],

Cell["\<\
Filtra primero dejando pasar solamente la frecuencia m\[AAcute]s baja, despu\
\[EAcute]s dejando pasar s\[OAcute]lo la frecuencia media y finalmente \
dejando pasar solamente la m\[AAcute]s alta. Ponle nombres a los objetos \
SampledSoundList[ ] que obtienes de esta forma y reprod\[UAcute]celos \
individualmente con Show[Sound[\"nombre\"]] y conjuntamente con el comando \
CombinedSoundShow[ ].\
\>", "Text"],

Cell["\<\
Ahora prueba con el archivo \"pavrti.wav\" o si lo prefieres el archivo \
\"nes.wav\" que exportaste antes y que es m\[AAcute]s peque\[NTilde]o que \
\"pavrti.wav\". Elijas el que elijas, lo primero que tienes que hacer es \
importarlo y ponerle nombre, por ejemplo \"nesun\". Despu\[EAcute]s puedes \
hacer lo que te sugiero para ver c\[OAcute]mo el filtro selecciona \
frecuencias.\
\>", "Text"],

Cell[BoxData[{
    \(\(nesunbajo = 
        filtropasobanda[nesun[\([\)\(1\)\(]\)], 0, 1000];\)\), "\n", 
    \(\(Show[Sound[nesunbajo]];\)\), "\n", 
    \(\(nesunmedio = 
        filtropasobanda[nessun[\([\)\(1\)\(]\)], 1000, 2000];\)\), "\n", 
    \(\(Show[Sound[nesunmedio]];\)\), "\n", 
    \(\(nesunalto = 
        filtropasobanda[nessun[\([\)\(1\)\(]\)], 2000, 8000];\)\), "\n", 
    \(\(Show[Sound[nesunalto]];\)\), "\n", 
    \(\(CombinedSoundShow[{nesun, Sound[nesunbajo], Sound[nesunmedio], 
          Sound[nesunalto]}];\)\)}], "Input"],

Cell["\<\
Esto casi se aprecia mejor en archivos de voz. Con esta pr\[AAcute]ctica habr\
\[AAcute]s bajado un archivo \"papa.wav\" que contiene la voz de un ni\
\[NTilde]o, hijo de un compa\[NTilde]ero mio, que dice muy alegre \"Pap\
\[AAcute], me gusta el ordenador...\" (quiz\[AAcute]s as\[IAcute] empezaste t\
\[UAcute] y mira d\[OAcute]nde est\[AAcute]s ahora...). Importa el archivo y \
ponle nombre, por ejemplo, \"ninio\" y p\[AAcute]sale el filtro para \
seleccionar frecuencias bajas entre 0 y 1000 hercios, frecuencias medias \
entre 1000 y 2000 hercios y frecuencias altas entre 2000 y 4000 hercios. Ver\
\[AAcute]s que los cambios en la voz son muy notables.\
\>", "Text"],

Cell["\<\
Ya te habr\[AAcute]s dado cuenta que el filtro que hemos construido sirve \
tambi\[EAcute]n como filtro paso bajo y como filtro paso alto: basta para \
ello elegir el rango de frecuencias apropiado. \
\>", "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Filtrado lineal", "Section"],

Cell["\<\
En la secci\[OAcute]n anterio, al llegar a la igualdad de convoluci\[OAcute]n \
(convoluci\[OAcute]n que  a veces se llama \"lineal\" para distinguirla de la \
convoluci\[OAcute]n circular)\
\>", "Text"],

Cell[BoxData[
    \(TraditionalForm\`y(
        n) = \[Sum]\+\(k = 0\)\%\(M - 1\)\(h(k)\) \(x(
            n - k)\)\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \((3)\)\)], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "se supuso que la se\[NTilde]al de entrada ",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          RowBox[{
            StyleBox["x",
              FontWeight->"Bold"], "=", \(x \((n)\)\)}]}], 
        TraditionalForm]]],
  " tiene igual duraci\[OAcute]n finita que la respuesta impulso y que ambas \
se\[NTilde]ales son peri\[OAcute]dicas con per\[IAcute]odo ",
  Cell[BoxData[
      \(TraditionalForm\`M\)]],
  ". Pong\[AAcute]monos ahora en el caso general en que no se supone \
periodicidad y supongamos que la se\[NTilde]al ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["x",
            FontWeight->"Bold"], 
          StyleBox["=",
            FontWeight->"Plain"], 
          StyleBox[\(x(n)\),
            FontWeight->"Plain"]}], TraditionalForm]]],
  " tiene longitud ",
  Cell[BoxData[
      \(TraditionalForm\`Q\)]],
  ", es decir, ",
  Cell[BoxData[
      \(TraditionalForm\`x(n) = 0\)]],
  " para ",
  Cell[BoxData[
      \(TraditionalForm\`n < 0\)]],
  " y para ",
  Cell[BoxData[
      \(TraditionalForm\`n \[GreaterEqual] Q\)]],
  ". Entonces la duraci\[OAcute]n de la se\[NTilde]al ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["y",
            FontWeight->"Bold"], 
          StyleBox["=",
            FontWeight->"Plain"], 
          StyleBox[\(y(n)\),
            FontWeight->"Plain"]}], TraditionalForm]]],
  " dada por la igualdad (3) es ",
  Cell[BoxData[
      \(TraditionalForm\`Q + M - 1\)]],
  ". Pues podemos escribir"
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`y(
        n) = \(\[Sum]\+\(k = 0\)\%\(M - 1\)\(h(k)\) \(x(
              n - k)\) = \[Sum]\+\(\(k + j = n\)\(,\)\(\ \)\((k + j \
\[LessEqual] M + Q - 2)\)\(\ \)\)\(h(k)\) \(x(
              j)\)\ \ \ \ \ \ \ \ \ \ \((3)\)\)\)], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "y por tanto ",
  Cell[BoxData[
      \(TraditionalForm\`y(n)\)]],
  " es igual al coeficiente de ",
  Cell[BoxData[
      \(TraditionalForm\`x\^n\)]],
  " en el producto de los polinomios de grados ",
  Cell[BoxData[
      \(TraditionalForm\`M - 1\)]],
  " y  ",
  Cell[BoxData[
      \(TraditionalForm\`Q - 1\)]],
  ":"
}], "Text"],

Cell[TextData[Cell[BoxData[
    \(TraditionalForm\`\((\(h(0) + \(h(1)\) x + \(h(2)\) x\^2 + \(h(3)\) 
                x\^3 +  ... \) + \(h(M - 1)\) 
            x\^\(M - 1\))\) \((\(x(0) + \(x(1)\) x + \(x(2)\) 
                x\^2 +  ... \) + \(x(Q - 1)\) x\^\(Q - 1\))\)\)]]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "El resultado del producto es un polinomio de grado ",
  Cell[BoxData[
      \(TraditionalForm\`M + Q - 2\)]],
  " que tiene ",
  Cell[BoxData[
      \(TraditionalForm\`M + Q - 1\)]],
  " coeficientes que ser\[AAcute] la longitud de la se\[NTilde]al ",
  Cell[BoxData[
      FormBox[
        StyleBox["y",
          FontWeight->"Bold"], TraditionalForm]]],
  ".",
  StyleBox[" Mathematica",
    FontSlant->"Italic"],
  " tiene un comando bastante r\[AAcute]pido y eficaz que calcula los \
coeficientes de un producto de polinomios (el comando \"ListConvolve[ ] no se \
adapta para este c\[AAcute]lculo)."
}], "Text"],

Cell[BoxData[
    \(\(\( (*\ vamos\ a\ considerar\ que\ x \((0)\) = 1, \ 
      x \((1)\) = \(-2\), \ x \((2)\) = 1, \ x \((3)\) = \(-1\), \ 
      son\ los\ valores\ no\ nulos\ de\ la\ se\[NTilde]al\ x, \ 
      h \((0)\) = 2, \ h \((2)\) = \(-1\), \ 
      h \((7)\) = \(\(-1\)\ son\ los\ valores\ no\ nulos\ de\ la\ \
se\[NTilde]al\ h . \ Tenemos\ que\ M = 8\), \ 
      Q = 4\ *) \)\(\[IndentingNewLine]\)\(CoefficientList[\((1 - 2  z + 
            z\^2 - z\^3)\)*\((2 - z\^2 - z\^7)\), z]\)\( (*\ 
      una\ forma\ de\ calcular\ x\[Star]h\ *) \)\)\)], "Input"],

Cell[TextData[{
  "Con esta interpretaci\[OAcute]n es evidente que si a\[NTilde]adimos \
valores nulos de las se\[NTilde]ales ",
  Cell[BoxData[
      FormBox[
        StyleBox["x",
          FontWeight->"Bold"], TraditionalForm]]],
  " y ",
  Cell[BoxData[
      FormBox[
        StyleBox["h",
          FontWeight->"Bold"], TraditionalForm]]],
  "  y los hacemos intervenir en los c\[AAcute]lculos la convoluci\[OAcute]n \
resultante es la misma que la anterior con ceros a\[NTilde]adidos al final."
}], "Text"],

Cell[BoxData[
    \(CoefficientList[\((1 - 2  z + z\^2 - z\^3 + 0. \ z\^4 + 0.  z\^5 + 
            0.  z\^6 + 0.  z\^7)\)*\((2 - z\^2 - z\^7)\), z]\)], "Input"],

Cell[TextData[{
  "Lo anterior tiene por objetivo ver que la convoluci\[OAcute]n (3) podemos \
expresarla como una convoluci\[OAcute]n c\[IAcute]clica. Para ello lo que \
hacemos es calcular la convoluci\[OAcute]n de las se\[NTilde]ales de igual \
longitud ",
  Cell[BoxData[
      \(TraditionalForm\`M + Q - 1\)]],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`x(k), \ h(k), \ 
      0 \[LessEqual] k \[LessEqual] M + Q - 1\)]],
  ", es decir consideramos algunos t\[EAcute]rminos adicionales nulos, y la \
convoluci\[OAcute]n c\[IAcute]clica correspondiente es justamente ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(x\[Star]h\),
          FontWeight->"Bold"], TraditionalForm]]],
  "."
}], "Text"],

Cell[BoxData[
    \(ListConvolve[{1, \(-2\), 1, \(-1\), 0, 0, 0, 0, 0, 0, 0}, {2, 
        0, \(-1\), 0, 0, 0, 0, \(-1\), 0, 0, 0}, 1]\)], "Input"],

Cell["\<\
Comprueba el resultado anterior con el comando \"CiclicConvolve[ ]\" que has \
definido en el ejercicio 3.\
\>", "Text"],

Cell[BoxData[
    \(CiclicConvolve[{1, \(-2\), 1, \(-1\), 0, 0, 0, 0, 0, 0, 0}, {2, 
        0, \(-1\), 0, 0, 0, 0, \(-1\), 0, 0, 0}]\)], "Input"],

Cell[BoxData[
    \(Fourier[{2, \(-4\), 1, 0, \(-1\), 1, 0, \(-1\), 2, \(-1\), 1}] - \@11*
          Fourier[{1, \(-2\), 1, \(-1\), 0, 0, 0, 0, 0, 0, 0}]*
          Fourier[{2, 0, \(-1\), 0, 0, 0, 0, \(-1\), 0, 0, 0}] // 
      Chop\)], "Input"],

Cell[TextData[{
  "Con lo anterior hemos justificado que todo filtro en las condiciones \
consideradas, sin m\[AAcute]s que a\[NTilde]adir ceros en la forma que se ha \
indicado, act\[UAcute]a por convoluci\[OAcute]n c\[IAcute]clica. Es aqu\
\[IAcute] donde entra, ya era hora, la DFT. Podemos por ello representar la \
acci\[OAcute]n del filtro en la forma ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["y",
            FontWeight->"Bold"], 
          StyleBox["=",
            FontWeight->"Bold"], 
          RowBox[{
            StyleBox["x",
              FontWeight->"Bold"], 
            StyleBox["\[CircleDot]",
              FontWeight->"Bold"], 
            StyleBox[" ",
              FontWeight->"Bold"], 
            StyleBox["h",
              FontWeight->"Bold"]}]}], TraditionalForm]]],
  "; donde ahora ",
  Cell[BoxData[
      FormBox[
        StyleBox["x",
          FontWeight->"Bold"], TraditionalForm]]],
  " y ",
  Cell[BoxData[
      FormBox[
        StyleBox["h",
          FontWeight->"Bold"], TraditionalForm]]],
  " son vectores de longitud ",
  Cell[BoxData[
      \(TraditionalForm\`N = M + Q - 1\)]],
  ". Tomando transformadas de Fourier discretas como las que usa ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " por defecto obtenemos, notando las correspondiente transformadas con \
letras may\[UAcute]sculas, ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(Y = \@N\ X\ H\),
          FontWeight->"Bold"], TraditionalForm]]],
  " donde el producto ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(X\ H\),
          FontWeight->"Bold"], TraditionalForm]]],
  " se entiende coordenada a coordenada. La se\[NTilde]al ",
  Cell[BoxData[
      FormBox[
        StyleBox["H",
          FontWeight->"Bold"], TraditionalForm]]],
  " se llama funci\[OAcute]n de transferencia del filtro y es la DFT de la \
funci\[OAcute]n impulso respuesta (de longitud ",
  Cell[BoxData[
      \(TraditionalForm\`N\)]],
  "). Este procedimiento se conoce como ",
  StyleBox["filtrado lineal.",
    FontSlant->"Italic"]
}], "Text"],

Cell[TextData[{
  "Nota: En la definici\[OAcute]n del filtro de la secci\[OAcute]n anterior, \
no es imprescindible multiplicar por 2 para definir \"newsize\", pero hacerlo \
mejora los resultados del filtro y asegura que a\[NTilde]adiremos suficientes \
ceros para que la convoluci\[OAcute]n c\[IAcute]clica de la nueva muestra con \
ceros a\[NTilde]adidos represente al filtro sin necesidad de \
hip\[OAcute]tesis de periodicidad. Oberva que la longitud de la \
funci\[OAcute]n de transferencia es \"newfmax\"-\"newfmin\" y la longitud \
\"newsize\" debe verificar que \
\"newsize\"\[GreaterEqual]\"origsize\"+\"newfmax\"-\"newfmin\"-1; si al \
elegir \"newsize\" se multiplica por 2, esta condici\[OAcute]n se cumple \
siempre que ",
  Cell[BoxData[
      \(TraditionalForm\`"fmax" - "fmin" \[LessEqual] srate\/2\)]],
  " lo que normalmente se satisface."
}], "Text"],

Cell["\<\
Hay que advertir que los dos m\[EAcute]todos no son equivalentes. \
Ve\[AAcute]moslo con un ejemplo.\
\>", "Text"],

Cell["Comparaci\[OAcute]n de los m\[EAcute]todos de filtrado lineal y peri\
\[OAcute]dico", "Definition"],

Cell[TextData[{
  "Consideremos un filtro cuya ",
  StyleBox["funci\[OAcute]n impulso",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " venga dada como sigue."
}], "Text"],

Cell[BoxData[{
    \(\(funpulso = 
        Table[Exp[\(-0.01\)\ t], {t, 0, 511}]/\((Plus @@ 
              Table[Exp[\(-0.01\)\ t], {t, 0, 511}])\);\)\), "\n", 
    \(\(ListPlot[funpulso];\)\)}], "Input"],

Cell["Consideremos una se\[NTilde]al que vamos a generar aleatoriamente.", \
"Text"],

Cell[BoxData[{
    \(\(signal = 
        NestList[#1\ If[Random[] < 0.01, \(-1.0\), 1.0] &, 1, 
          511];\)\), "\n", 
    \(\(\(ListPlot[signal]\)\(\ \)\(;\)\( (*\ 
      cada\ vez\ que\ ejecutes\ el\ comando\ saldr\[AAcute]\ una\ \
se\[NTilde]al\ distinta . \ 
          Trata\ de\ obtener\ una\ que\ te\ guste\ *) \)\)\)}], "Input",
  AspectRatioFixed->True],

Cell["\<\
Observa que \"signal\" y \"funpulso\" tiene igual longitud 512. La respuesta \
de este filtro a \" a \"signal\" se puede obtener interpretando que hay \
periodicidad por convoluci\[OAcute]n c\[IAcute]clica, lo que a su vez podemos \
hacer directamente o, indirectamente usando la DFT y su inversa (cuando los c\
\[AAcute]lculos son muy largos este procedimiento es el m\[AAcute]s eficaz). \
\
\>", "Text"],

Cell[BoxData[{
    \(\(respuesta = 
          Chop[Sqrt[512] 
              InverseFourier[Fourier[signal]*\ Fourier[funpulso]]];\) // 
      Timing\), "\[IndentingNewLine]", 
    \(\(respuesta2 = Chop[ListConvolve[signal, funpulso, 1]];\) // 
      Timing\)}], "Input"],

Cell[BoxData[{
    \(respuesta \[Equal] respuesta2\  (*\ puede\ dar\ False, \ 
      depende\ de\ la\ se\[NTilde]al\ que\ se\ genere\ *) \), "\n", 
    \(Chop[respuesta - respuesta2] \[Equal] 
      Table[0, {512}]\), "\[IndentingNewLine]", 
    \( (*\ 
      suelen\ producirse\ peque\[NTilde]os\ errores\ de\ redondeo\ *) \)}], \
"Input"],

Cell["Obtengamos ahora la respuesta sin suponer periodicidad.", "Text"],

Cell[BoxData[{
    \(\(nuevasignal = 
        Join[signal, Table[0, {511}]];\)\), "\[IndentingNewLine]", 
    \(\(nuevafunpulso = 
        Join[funpulso, Table[0, {511}]];\)\), "\[IndentingNewLine]", 
    \(\(nuevarespuesta = 
          Chop[\(\@1023\) 
              InverseFourier[
                Fourier[nuevasignal]*Fourier[nuevafunpulso]]];\) // 
      Timing\)}], "Input"],

Cell["Comparemos los resultados obtenidos.", "Text"],

Cell[BoxData[
    \(\(\(g1 = ListPlot[respuesta]\)\(;\)\( (*\ 
      observa\ c\[OAcute]mo\ la\ convoluci\[OAcute]n\ suaviza\ la\ \
se\[NTilde]al\ de\ entrada\ *) \)\)\)], "Input"],

Cell[BoxData[
    \(\(ListPlot[nuevarespuesta];\)\)], "Input"],

Cell["\<\
Como puedes ver son muy diferentes. Para comparar mejor tomemos los primeros \
512 elementos de \"nuevarespuesta\".\
\>", "Text"],

Cell[BoxData[
    \(\(g2 = ListPlot[Take[nuevarespuesta, 512]];\)\)], "Input"],

Cell["Superpongamos las gr\[AAcute]ficas.", "Text"],

Cell[BoxData[
    \(Show[g1, g2]\)], "Input"],

Cell["\<\
Bueno, no son \"demasiado\" diferentes y las diferencias mayores se producen \
al principio. \
\>", "Text"]
}, Open  ]]
},
FrontEndVersion->"5.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 685}},
WindowSize->{1016, 635},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
Magnification->1.5,
StyleDefinitions -> "Classroom.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.51.1"->{
    Cell[52408, 1429, 63, 1, 71, "Input",
      CellTags->"S5.51.1"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.51.1", 87025, 2376}
  }
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 49, 0, 99, "Title"],
Cell[1806, 53, 170, 2, 102, "Author"],

Cell[CellGroupData[{
Cell[2001, 59, 39, 0, 93, "Section"],
Cell[2043, 61, 727, 13, 145, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2807, 79, 70, 0, 93, "Section"],
Cell[2880, 81, 1286, 39, 93, "Text"],
Cell[4169, 122, 378, 6, 77, "Text"],
Cell[4550, 130, 82, 1, 41, "Text"],
Cell[4635, 133, 368, 7, 77, "Text"],
Cell[5006, 142, 6428, 187, 600, "Text"],
Cell[11437, 331, 1001, 25, 40, "Text"],
Cell[12441, 358, 32, 0, 41, "Text"],
Cell[12476, 360, 697, 19, 57, "Text"],
Cell[13176, 381, 213, 4, 150, "Input"],

Cell[CellGroupData[{
Cell[13414, 389, 31, 0, 68, "Exercise"],
Cell[13448, 391, 3185, 70, 701, "ExerciseText"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[16682, 467, 51, 0, 93, "Section"],
Cell[16736, 469, 408, 7, 93, "Text"],
Cell[17147, 478, 1501, 42, 162, "Text"],
Cell[18651, 522, 367, 7, 172, "Input"],
Cell[19021, 531, 485, 8, 198, "Input"],
Cell[19509, 541, 348, 7, 172, "Input"],
Cell[19860, 550, 381, 11, 67, "Text"],
Cell[20244, 563, 557, 11, 250, "Input"],
Cell[20804, 576, 152, 3, 41, "Text"],
Cell[20959, 581, 76, 1, 117, "Input"],
Cell[21038, 584, 153, 2, 94, "Input"],
Cell[21194, 588, 525, 10, 250, "Input"],
Cell[21722, 600, 1340, 31, 197, "Text"],
Cell[23065, 633, 472, 9, 224, "Input"],
Cell[23540, 644, 412, 7, 93, "Text"],
Cell[23955, 653, 165, 3, 67, "Text"],
Cell[24123, 658, 1465, 27, 484, "Input"],
Cell[25591, 687, 44, 1, 94, "Input"],
Cell[25638, 690, 596, 9, 119, "Text"],
Cell[26237, 701, 228, 4, 67, "Text"],
Cell[26468, 707, 44, 1, 94, "Input"],
Cell[26515, 710, 559, 9, 119, "Text"],
Cell[27077, 721, 600, 11, 250, "Input"],
Cell[27680, 734, 413, 7, 93, "Text"],
Cell[28096, 743, 136, 3, 41, "Text"],
Cell[28235, 748, 1086, 25, 354, "Input"],
Cell[29324, 775, 692, 16, 119, "Text"],
Cell[30019, 793, 590, 17, 67, "Text"],

Cell[CellGroupData[{
Cell[30634, 814, 31, 0, 68, "Exercise"],
Cell[30668, 816, 1379, 39, 183, "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[32096, 861, 94, 4, 93, "Section"],
Cell[32193, 867, 1141, 27, 201, "Text"],
Cell[33337, 896, 71, 1, 72, "Input"],
Cell[33411, 899, 128, 3, 72, "Input"],
Cell[33542, 904, 197, 3, 98, "Input"],
Cell[33742, 909, 115, 3, 41, "Text"],
Cell[33860, 914, 486, 10, 202, "Input"],
Cell[34349, 926, 380, 8, 93, "Text"],
Cell[34732, 936, 299, 7, 150, "Input"],
Cell[35034, 945, 59, 0, 41, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[35130, 950, 91, 1, 93, "Section"],
Cell[35224, 953, 2434, 73, 260, "Text"],
Cell[37661, 1028, 140, 5, 41, "Text"],

Cell[CellGroupData[{
Cell[37826, 1037, 31, 0, 68, "Exercise"],
Cell[37860, 1039, 1295, 33, 169, "ExerciseText"],
Cell[39158, 1074, 431, 12, 67, "Text"],
Cell[39592, 1088, 70, 1, 72, "Input"],
Cell[39665, 1091, 196, 5, 41, "Text"],
Cell[39864, 1098, 153, 3, 40, "Text"],
Cell[40020, 1103, 420, 12, 66, "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[40489, 1121, 130, 5, 93, "Section"],
Cell[40622, 1128, 456, 11, 93, "Text"],
Cell[41081, 1141, 44, 0, 71, "Definition"],
Cell[41128, 1143, 979, 14, 197, "Text"],
Cell[42110, 1159, 379, 6, 176, "Input"],
Cell[42492, 1167, 299, 4, 124, "Input"],
Cell[42794, 1173, 150, 3, 41, "Text"],
Cell[42947, 1178, 469, 8, 206, "Input"],
Cell[43419, 1188, 92, 1, 72, "Input"],
Cell[43514, 1191, 40, 0, 71, "Definition"],
Cell[43557, 1193, 824, 12, 171, "Text"],
Cell[44384, 1207, 71, 1, 72, "Input"],
Cell[44458, 1210, 189, 4, 98, "Input"],
Cell[44650, 1216, 303, 4, 150, "Input"],
Cell[44956, 1222, 264, 4, 124, "Input"],
Cell[45223, 1228, 152, 3, 41, "Text"],
Cell[45378, 1233, 415, 8, 176, "Input"],
Cell[45796, 1243, 198, 3, 98, "Input"],
Cell[45997, 1248, 128, 3, 41, "Text"],
Cell[46128, 1253, 105, 2, 72, "Input"],
Cell[46236, 1257, 96, 2, 71, "Definition"],
Cell[46335, 1261, 356, 6, 93, "Text"],
Cell[46694, 1269, 79, 1, 72, "Input"],
Cell[46776, 1272, 604, 9, 145, "Text"],
Cell[47383, 1283, 86, 1, 72, "Input"],
Cell[47472, 1286, 782, 13, 145, "Text"],
Cell[48257, 1301, 116, 3, 41, "Text"],
Cell[48376, 1306, 369, 7, 176, "Input"],
Cell[48748, 1315, 133, 3, 72, "Input"],
Cell[48884, 1320, 132, 2, 98, "Input"],
Cell[49019, 1324, 65, 0, 41, "Text"],
Cell[49087, 1326, 303, 6, 150, "Input"],
Cell[49393, 1334, 172, 3, 98, "Input"],
Cell[49568, 1339, 60, 1, 72, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[49665, 1345, 50, 0, 93, "Section"],
Cell[49718, 1347, 446, 9, 93, "Text"],
Cell[50167, 1358, 135, 2, 98, "Input"],
Cell[50305, 1362, 142, 3, 72, "Input"],
Cell[50450, 1367, 250, 6, 67, "Text"],
Cell[50703, 1375, 134, 2, 72, "Input"],
Cell[50840, 1379, 163, 3, 67, "Text"],
Cell[51006, 1384, 61, 1, 72, "Input"],
Cell[51070, 1387, 82, 1, 41, "Text"],
Cell[51155, 1390, 91, 1, 72, "Input"],
Cell[51249, 1393, 213, 4, 67, "Text"],
Cell[51465, 1399, 68, 1, 72, "Input"],
Cell[51536, 1402, 60, 0, 41, "Text"],
Cell[51599, 1404, 52, 1, 72, "Input"],
Cell[51654, 1407, 92, 1, 41, "Text"],
Cell[51749, 1410, 77, 1, 72, "Input"],
Cell[51829, 1413, 89, 1, 41, "Text"],
Cell[51921, 1416, 70, 1, 72, "Input"],
Cell[51994, 1419, 411, 8, 93, "Text"],
Cell[52408, 1429, 63, 1, 71, "Input",
  CellTags->"S5.51.1"],
Cell[52474, 1432, 458, 9, 93, "Text"],
Cell[52935, 1443, 194, 5, 98, "Input"],
Cell[53132, 1450, 201, 6, 41, "Text"],
Cell[53336, 1458, 46, 1, 72, "Input"],
Cell[53385, 1461, 48, 1, 72, "Input"],
Cell[53436, 1464, 78, 1, 72, "Input"],
Cell[53517, 1467, 68, 1, 72, "Input"],
Cell[53588, 1470, 385, 8, 93, "Text"],
Cell[53976, 1480, 309, 8, 72, "Input"],
Cell[54288, 1490, 469, 11, 180, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[54794, 1506, 56, 0, 93, "Section"],
Cell[54853, 1508, 871, 26, 93, "Text"],
Cell[55727, 1536, 808, 23, 75, "Text"],
Cell[56538, 1561, 461, 15, 41, "Text"],
Cell[57002, 1578, 347, 10, 73, "Text"],
Cell[57352, 1590, 1586, 45, 145, "Text"],
Cell[58941, 1637, 191, 4, 77, "Text"],
Cell[59135, 1643, 2352, 66, 200, "Text"],
Cell[61490, 1711, 3418, 97, 329, "Text"],

Cell[CellGroupData[{
Cell[64933, 1812, 31, 0, 68, "Exercise"],
Cell[64967, 1814, 6213, 111, 1391, "ExerciseText"],
Cell[71183, 1927, 75, 0, 41, "Text"],
Cell[71261, 1929, 250, 5, 124, "Input"],
Cell[71514, 1936, 420, 7, 93, "Text"],
Cell[71937, 1945, 407, 7, 93, "Text"],
Cell[72347, 1954, 547, 11, 254, "Input"],
Cell[72897, 1967, 684, 10, 145, "Text"],
Cell[73584, 1979, 223, 4, 67, "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[73856, 1989, 34, 0, 93, "Section"],
Cell[73893, 1991, 213, 4, 67, "Text"],
Cell[74109, 1997, 191, 4, 77, "Text"],
Cell[74303, 2003, 1534, 50, 119, "Text"],
Cell[75840, 2055, 298, 6, 80, "Text"],
Cell[76141, 2063, 351, 14, 41, "Text"],
Cell[76495, 2079, 312, 5, 36, "Text"],
Cell[76810, 2086, 634, 18, 93, "Text"],
Cell[77447, 2106, 567, 9, 150, "Input"],
Cell[78017, 2117, 513, 14, 67, "Text"],
Cell[78533, 2133, 161, 2, 99, "Input"],
Cell[78697, 2137, 710, 18, 93, "Text"],
Cell[79410, 2157, 147, 2, 98, "Input"],
Cell[79560, 2161, 130, 3, 41, "Text"],
Cell[79693, 2166, 146, 2, 98, "Input"],
Cell[79842, 2170, 245, 4, 131, "Input"],
Cell[80090, 2176, 2082, 61, 198, "Text"],
Cell[82175, 2239, 870, 15, 150, "Text"],
Cell[83048, 2256, 124, 3, 41, "Text"],
Cell[83175, 2261, 105, 1, 71, "Definition"],
Cell[83283, 2264, 177, 6, 42, "Text"],
Cell[83463, 2272, 204, 4, 124, "Input"],
Cell[83670, 2278, 84, 1, 41, "Text"],
Cell[83757, 2281, 366, 8, 124, "Input"],
Cell[84126, 2291, 415, 7, 93, "Text"],
Cell[84544, 2300, 270, 6, 150, "Input"],
Cell[84817, 2308, 340, 7, 150, "Input"],
Cell[85160, 2317, 71, 0, 41, "Text"],
Cell[85234, 2319, 379, 9, 214, "Input"],
Cell[85616, 2330, 52, 0, 41, "Text"],
Cell[85671, 2332, 180, 3, 98, "Input"],
Cell[85854, 2337, 62, 1, 72, "Input"],
Cell[85919, 2340, 139, 3, 41, "Text"],
Cell[86061, 2345, 78, 1, 72, "Input"],
Cell[86142, 2348, 51, 0, 41, "Text"],
Cell[86196, 2350, 45, 1, 72, "Input"],
Cell[86244, 2353, 117, 3, 41, "Text"]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

